/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.storage;

import com.fuzs.menucompanions.client.handler.MenuEntityHandler;
import com.fuzs.menucompanions.client.storage.EntityMenuEntry;
import com.fuzs.menucompanions.client.storage.MenuEntryBuilder;
import com.fuzs.menucompanions.config.JSONConfigUtil;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;

public class MenuEntityProvider {
    private static final List<EntityMenuEntry> DEFAULT_MENU_ENTRIES = Lists.newArrayList((Object[])new EntityMenuEntry[]{new MenuEntryBuilder().setType(EntityType.field_200729_aH).setRight().setWeight(31).renderName().build(), new MenuEntryBuilder().setType(EntityType.field_200729_aH).setRight().renderName().setNbt("{ArmorItems:[{Count:1,id:netherite_boots},{Count:1,id:netherite_leggings},{Count:1,id:netherite_chestplate},{Count:1,id:netherite_helmet}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233592_ba_).setLeft().setWeight(13).build(), new MenuEntryBuilder().setType(EntityType.field_233592_ba_).setLeft().setWeight(2).setNbt("{IsBaby:1,HandItems:[{Count:1,id:golden_sword},{}]}").build(), new MenuEntryBuilder().setType(EntityType.field_200795_i).setLeft().setNbt("{Passengers:[{id:zombified_piglin,IsBaby:1,HandItems:[{Count:1,id:golden_sword},{}]}]}").build(), new MenuEntryBuilder().setType(EntityType.field_200811_y).setLeft().setWeight(10).setYOffset(24).setScale(0.4f).build(), new MenuEntryBuilder().setType(EntityType.field_200771_K).setLeft().setWeight(5).setNbt("{Size:0}").build(), new MenuEntryBuilder().setType(EntityType.field_200771_K).setLeft().setWeight(5).setNbt("{Size:1}").build(), new MenuEntryBuilder().setType(EntityType.field_200771_K).setLeft().setWeight(5).setNbt("{Size:3}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setWeight(10).build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:crimson_fungus}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:warped_fungus}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:crimson_roots}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:warped_roots}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:crimson_nylium}}").build(), new MenuEntryBuilder().setType(EntityType.field_200803_q).setLeft().setNbt("{carriedBlockState:{Name:warped_nylium}}").build(), new MenuEntryBuilder().setType(EntityType.field_200792_f).setLeft().setWeight(16).build(), new MenuEntryBuilder().setType(EntityType.field_200722_aA).setLeft().setWeight(13).build(), new MenuEntryBuilder().setType(EntityType.field_200741_ag).setLeft().setWeight(3).build(), new MenuEntryBuilder().setType(EntityType.field_233591_ai_).setLeft().setWeight(13).build(), new MenuEntryBuilder().setType(EntityType.field_233591_ai_).setLeft().setWeight(3).setNbt("{IsBaby:1}").build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setWeight(12).build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000}").build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000,Passengers:[{id:piglin,IsBaby:1}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000,Passengers:[{id:piglin,IsBaby:1,Passengers:[{id:piglin,IsBaby:1}]}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233588_G_).setLeft().setNbt("{Age:-24000,Passengers:[{id:piglin,IsBaby:1,Passengers:[{id:piglin,IsBaby:1,Passengers:[{id:piglin,IsBaby:1}]}]}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233590_aW_).setLeft().build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(10).build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(2).setNbt("{Age:-24000}").build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(3).setNbt("{Passengers:[{id:strider,Age:-24000}]}").build(), new MenuEntryBuilder().setType(EntityType.field_233589_aE_).setLeft().setWeight(1).setNbt("{Saddle:1,Passengers:[{id:zombified_piglin,HandItems:[{Count:1,id:warped_fungus_on_a_stick},{}]}]}").build()});
    private static final List<EntityMenuEntry> MENU_ENTRIES = Lists.newArrayList();

    @Nullable
    public static EntityMenuEntry getRandomEntry(MenuEntityHandler.MenuSide side) {
        List sidedEntries = MENU_ENTRIES.stream().filter(entry -> entry.isSide(side)).collect(Collectors.toList());
        if (sidedEntries.isEmpty()) {
            return null;
        }
        int weight = (int)((double)sidedEntries.stream().mapToInt(EntityMenuEntry::getWeight).sum() * Math.random());
        Collections.shuffle(sidedEntries);
        for (EntityMenuEntry entry2 : sidedEntries) {
            if ((weight -= entry2.getWeight()) > 0) continue;
            return entry2;
        }
        return null;
    }

    public static void serialize(String jsonName, File jsonFile) {
        JsonArray jsonarray = new JsonArray();
        DEFAULT_MENU_ENTRIES.forEach(entry -> jsonarray.add(entry.serialize()));
        JSONConfigUtil.saveToFile(jsonName, jsonFile, (JsonElement)jsonarray);
    }

    public static void deserialize(FileReader reader) {
        MENU_ENTRIES.clear();
        Stream.of((Object[])JSONConfigUtil.GSON.fromJson((Reader)reader, JsonElement[].class)).forEach(element -> Optional.ofNullable(MenuEntryBuilder.deserialize(element)).ifPresent(MENU_ENTRIES::add));
    }
}

