/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.storage;

import com.fuzs.menucompanions.MenuCompanions;
import com.fuzs.menucompanions.client.handler.MenuEntityHandler;
import com.fuzs.menucompanions.client.storage.EntityMenuEntry;
import com.fuzs.menucompanions.client.storage.PlayerMenuEntry;
import com.fuzs.menucompanions.client.util.IEntrySerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;

public class MenuEntryBuilder {
    private EntityType<?> type = null;
    private String nbt = "";
    private byte data = (byte)7;
    private float scale = 1.0f;
    private int xOffset = 0;
    private int yOffset = 0;
    private boolean nameplate = false;
    private boolean particles = true;
    private int weight = 1;
    private MenuEntityHandler.MenuSide side = MenuEntityHandler.MenuSide.BOTH;
    private String profile = "";
    private byte modelParts = (byte)127;
    private boolean crouching = false;

    public EntityMenuEntry build() {
        CompoundNBT compound = this.type != null ? IEntrySerializer.deserializeNbt(this.nbt, this.type) : new CompoundNBT();
        this.weight = Math.max(1, this.weight);
        if (this.type != null) {
            this.scale = this.scale != 1.0f ? this.scale : EntityMenuEntry.getScale(this.type.func_220333_h(), this.type.func_220344_i());
        } else {
            this.scale = 1.0f;
            this.xOffset = 0;
            this.yOffset = 0;
        }
        if (this.type == EntityType.field_200729_aH) {
            return new PlayerMenuEntry(this.type, compound, this.data, this.scale, this.xOffset, this.yOffset, this.nameplate, this.particles, this.weight, this.side, this.profile, this.modelParts, this.crouching);
        }
        return new EntityMenuEntry(this.type, compound, this.data, this.scale, this.xOffset, this.yOffset, this.nameplate, this.particles, this.weight, this.side);
    }

    public MenuEntryBuilder setType(EntityType<?> type) {
        this.type = type;
        return this;
    }

    public MenuEntryBuilder setNbt(String nbt) {
        this.nbt = nbt;
        return this;
    }

    public MenuEntryBuilder setData(byte data) {
        this.data = data;
        return this;
    }

    public MenuEntryBuilder setParticles(boolean particles) {
        this.particles = particles;
        return this;
    }

    public MenuEntryBuilder hideParticles() {
        this.particles = false;
        return this;
    }

    public MenuEntryBuilder setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public MenuEntryBuilder setXOffset(int xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public MenuEntryBuilder setYOffset(int yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    private MenuEntryBuilder setNameplate(boolean nameplate) {
        this.nameplate = nameplate;
        return this;
    }

    public MenuEntryBuilder renderName() {
        this.nameplate = true;
        return this;
    }

    public MenuEntryBuilder setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    private MenuEntryBuilder setSide(MenuEntityHandler.MenuSide side) {
        this.side = side;
        return this;
    }

    public MenuEntryBuilder setLeft() {
        this.side = MenuEntityHandler.MenuSide.LEFT;
        return this;
    }

    public MenuEntryBuilder setRight() {
        this.side = MenuEntityHandler.MenuSide.RIGHT;
        return this;
    }

    private MenuEntryBuilder setCrouching(boolean crouching) {
        this.crouching = crouching;
        return this;
    }

    public MenuEntryBuilder setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public MenuEntryBuilder setModelParts(byte modelParts) {
        this.modelParts = modelParts;
        return this;
    }

    public MenuEntryBuilder setCrouching() {
        this.crouching = true;
        return this;
    }

    @Nullable
    public static EntityMenuEntry deserialize(@Nullable JsonElement element) {
        if (element != null && element.isJsonObject()) {
            MenuEntryBuilder builder = new MenuEntryBuilder();
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)element, (String)"mob_entry");
            JsonObject displayobject = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"display");
            JsonObject dataobject = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"data");
            String id = JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"id");
            EntityType<?> type = null;
            if (!id.toLowerCase(Locale.ROOT).equals("random") && (type = IEntrySerializer.readEntityType(id)) == null) {
                MenuCompanions.LOGGER.warn("Unable to read entry with id {}", (Object)id);
                return null;
            }
            builder.setType(type);
            builder.setWeight(JSONUtils.func_151203_m((JsonObject)jsonobject, (String)"weight"));
            builder.setNameplate(JSONUtils.func_151212_i((JsonObject)displayobject, (String)"nameplate"));
            builder.setParticles(JSONUtils.func_151212_i((JsonObject)displayobject, (String)"particles"));
            builder.setSide(IEntrySerializer.deserializeEnum(displayobject, "side", MenuEntityHandler.MenuSide.class, MenuEntityHandler.MenuSide.BOTH));
            builder.setData(IEntrySerializer.deserializeEnumProperties(dataobject, EntityMenuEntry.PropertyFlags.class, EntityMenuEntry.PropertyFlags::toString, EntityMenuEntry.PropertyFlags::getPropertyMask));
            if (type != null) {
                builder.setScale(JSONUtils.func_151217_k((JsonObject)displayobject, (String)"scale"));
                builder.setXOffset(JSONUtils.func_151203_m((JsonObject)displayobject, (String)"x_offset"));
                builder.setYOffset(JSONUtils.func_151203_m((JsonObject)displayobject, (String)"y_offset"));
                builder.setNbt(JSONUtils.func_151200_h((JsonObject)dataobject, (String)"nbt"));
                if (type == EntityType.field_200729_aH) {
                    JsonObject playerobject = JSONUtils.func_152754_s((JsonObject)jsonobject, (String)"player");
                    JsonObject modelobject = JSONUtils.func_152754_s((JsonObject)playerobject, (String)"model");
                    builder.setProfile(JSONUtils.func_151200_h((JsonObject)playerobject, (String)"profile"));
                    builder.setCrouching(JSONUtils.func_151212_i((JsonObject)playerobject, (String)"crouching"));
                    builder.setModelParts(IEntrySerializer.deserializeEnumProperties(modelobject, PlayerModelPart.class, PlayerModelPart::func_179329_c, PlayerModelPart::func_179327_a));
                }
            }
            return builder.build();
        }
        return null;
    }
}

