/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.storage;

import com.fuzs.menucompanions.client.handler.MenuEntityHandler;
import com.fuzs.menucompanions.client.storage.EntityMenuEntry;
import com.fuzs.menucompanions.client.util.CreateEntityUtil;
import com.fuzs.menucompanions.client.util.IEntrySerializer;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.fuzs.menucompanions.mixin.EntityAccessorMixin;
import com.fuzs.menucompanions.mixin.PlayerEntityAccessorMixin;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.StringUtils;

public class PlayerMenuEntry
extends EntityMenuEntry {
    private final String profile;
    private final byte modelParts;
    private final boolean crouching;

    public PlayerMenuEntry(@Nullable EntityType<?> type, CompoundNBT compound, byte data, float scale, int xOffset, int yOffset, boolean nameplate, boolean particles, int weight, MenuEntityHandler.MenuSide side, String profile, byte modelParts, boolean crouching) {
        super(type, compound, data, scale, xOffset, yOffset, nameplate, particles, weight, side);
        this.profile = profile;
        this.modelParts = modelParts;
        this.crouching = crouching;
    }

    @Override
    @Nullable
    public Entity create(MenuClientWorld worldIn) {
        CreateEntityUtil.setGameProfile(PlayerMenuEntry.getGameProfile(this.profile));
        return CreateEntityUtil.loadEntity(EntityType.field_200729_aH, this.compound, worldIn, entity -> {
            entity.func_230245_c_(this.readProperty(EntityMenuEntry.PropertyFlags.ON_GROUND));
            ((EntityAccessorMixin)entity).setInWater(this.readProperty(EntityMenuEntry.PropertyFlags.IN_WATER));
            CreateEntityUtil.readLivingAdditional(entity, this.compound);
            entity.func_184212_Q().func_187227_b(PlayerEntityAccessorMixin.getPlayerModelFlag(), (Object)this.modelParts);
            if (this.crouching) {
                entity.func_213301_b(Pose.CROUCHING);
            }
            return entity;
        });
    }

    @Override
    public JsonElement serialize() {
        JsonObject jsonobject = super.serialize().getAsJsonObject();
        jsonobject.add("player", (JsonElement)this.serializePlayer());
        return jsonobject;
    }

    private JsonObject serializePlayer() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("profile", this.profile);
        jsonobject.addProperty("crouching", Boolean.valueOf(this.crouching));
        jsonobject.add("model", (JsonElement)this.serializeModel());
        return jsonobject;
    }

    private JsonObject serializeModel() {
        JsonObject jsonobject = new JsonObject();
        IEntrySerializer.serializeEnumProperties(jsonobject, PlayerModelPart.class, this.modelParts, PlayerModelPart::func_179329_c, PlayerModelPart::func_179327_a);
        return jsonobject;
    }

    private static GameProfile getGameProfile(String profile) {
        if (StringUtils.func_151246_b((String)profile)) {
            return Minecraft.func_71410_x().func_110432_I().func_148256_e();
        }
        return PlayerMenuEntry.updateGameProfile(new GameProfile(null, profile));
    }

    private static GameProfile updateGameProfile(GameProfile input) {
        GameProfile gameprofile = SkullTileEntity.func_174884_b((GameProfile)input);
        if (gameprofile == input) {
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(Minecraft.func_71410_x().field_71412_D, MinecraftServer.field_152367_a.getName()));
            SkullTileEntity.func_184293_a((PlayerProfileCache)playerprofilecache);
            SkullTileEntity.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            gameprofile = SkullTileEntity.func_174884_b((GameProfile)input);
        }
        return gameprofile;
    }
}

