/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.util;

import com.fuzs.menucompanions.MenuCompanions;
import com.fuzs.menucompanions.client.entity.MenuClientPlayerEntity;
import com.fuzs.menucompanions.client.handler.MenuEntityHandler;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Util;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class CreateEntityUtil {
    private static GameProfile gameProfile;

    @Nullable
    public static Entity loadEntity(EntityType<?> type, CompoundNBT compound, MenuClientWorld worldIn, Function<Entity, Entity> mapper) {
        CompoundNBT compoundnbt = compound.func_74737_b();
        compoundnbt.func_74778_a("id", Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(type)).toString());
        return CreateEntityUtil.loadEntityAndExecute(compoundnbt, worldIn, mapper);
    }

    @Nullable
    public static Entity loadEntityAndExecute(CompoundNBT compound, MenuClientWorld worldIn, Function<Entity, Entity> mapper) {
        return CreateEntityUtil.loadEntity(compound, worldIn).map(mapper).map(entity -> {
            if (compound.func_150297_b("Passengers", 9)) {
                ListNBT listnbt = compound.func_150295_c("Passengers", 10);
                for (int i = 0; i < listnbt.size(); ++i) {
                    Entity passenger = CreateEntityUtil.loadEntityAndExecute(listnbt.func_150305_b(i), worldIn, mapper);
                    if (passenger == null) continue;
                    passenger.func_184205_a(entity, true);
                    entity.func_184232_k(passenger);
                }
            }
            return entity;
        }).orElse(null);
    }

    private static Optional<Entity> loadEntity(CompoundNBT compound, MenuClientWorld worldIn) {
        try {
            return CreateEntityUtil.loadEntityUnchecked(compound, worldIn);
        }
        catch (RuntimeException runtimeexception) {
            MenuCompanions.LOGGER.warn("Exception loading entity: ", (Throwable)runtimeexception);
            MenuEntityHandler.addToBlacklist(compound.func_74779_i("id"));
            return Optional.empty();
        }
    }

    public static Optional<Entity> loadEntityUnchecked(CompoundNBT compound, MenuClientWorld worldIn) {
        return Util.func_215077_a(EntityType.func_220347_a((CompoundNBT)compound).map(entityType -> MenuEntityHandler.isAllowed(entityType) ? entityType : null).map(entityType -> CreateEntityUtil.create(worldIn, entityType)), entity -> {
            try {
                entity.func_70020_e(compound);
            }
            catch (Exception e) {
                CreateEntityUtil.readAngerableAdditional(entity, compound);
            }
        }, () -> {
            String id = compound.func_74779_i("id");
            MenuCompanions.LOGGER.warn("Skipping Entity with id {}", (Object)id);
            MenuEntityHandler.addToBlacklist(id);
        });
    }

    @Nullable
    public static Entity create(MenuClientWorld worldIn, EntityType<?> type) {
        if (type == EntityType.field_200729_aH && gameProfile != null) {
            return new MenuClientPlayerEntity(worldIn, gameProfile);
        }
        return type.func_200721_a((World)worldIn);
    }

    public static void setGameProfile(GameProfile input) {
        gameProfile = input;
    }

    public static void onInitialSpawn(Entity entity, IWorld worldIn, boolean noNbt) {
        entity.field_70173_aa = 2;
        entity.field_70145_X = true;
        if (noNbt && entity instanceof MobEntity) {
            try {
                DifficultyInstance difficulty = new DifficultyInstance(Difficulty.HARD, 100000L, 100000L, 1.0f);
                ((MobEntity)entity).func_213386_a(worldIn, difficulty, SpawnReason.COMMAND, null, null);
                if (entity instanceof AgeableEntity && ((AgeableEntity)entity).func_70681_au().nextFloat() <= 0.05f) {
                    ((AgeableEntity)entity).func_82227_f(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void readLivingAdditional(Entity entity, CompoundNBT compound) {
        ListNBT listnbt;
        if (compound.func_150297_b("ArmorItems", 9)) {
            listnbt = compound.func_150295_c("ArmorItems", 10);
            Stream.of(EquipmentSlotType.values()).filter(slot -> slot.func_188453_a() == EquipmentSlotType.Group.ARMOR).forEach(slot -> entity.func_184201_a(slot, ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(slot.func_188454_b()))));
        }
        if (compound.func_150297_b("HandItems", 9)) {
            listnbt = compound.func_150295_c("HandItems", 10);
            Stream.of(EquipmentSlotType.values()).filter(slot -> slot.func_188453_a() == EquipmentSlotType.Group.HAND).forEach(slot -> entity.func_184201_a(slot, ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(slot.func_188454_b()))));
        }
    }

    private static void readAngerableAdditional(Entity entity, CompoundNBT compound) {
        if (entity instanceof MobEntity) {
            CreateEntityUtil.readLivingAdditional(entity, compound);
        }
        if (entity instanceof EndermanEntity) {
            BlockState blockstate = null;
            if (compound.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("carriedBlockState"))).func_196958_f()) {
                blockstate = null;
            }
            ((EndermanEntity)entity).func_195406_b(blockstate);
        } else if (entity instanceof ZombifiedPiglinEntity) {
            ((ZombifiedPiglinEntity)entity).func_82227_f(compound.func_74767_n("IsBaby"));
        } else if (entity instanceof WolfEntity) {
            if (compound.func_150297_b("CollarColor", 99)) {
                ((WolfEntity)entity).func_175547_a(DyeColor.func_196056_a((int)compound.func_74762_e("CollarColor")));
            }
            ((WolfEntity)entity).func_70903_f(compound.func_186855_b("Owner") || !compound.func_74779_i("Owner").isEmpty());
            ((WolfEntity)entity).func_233687_w_(compound.func_74767_n("Sitting"));
            ((WolfEntity)entity).func_233686_v_(((WolfEntity)entity).func_233685_eM_());
        }
    }
}

