/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.util;

import com.fuzs.menucompanions.MenuCompanions;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public interface IEntrySerializer {
    public static final String RANDOM = "random";

    public static String serializeNBT(CompoundNBT nbt) {
        return nbt.func_197637_c().getString();
    }

    public static CompoundNBT deserializeNbt(String nbt, EntityType<?> type) {
        try {
            if (!nbt.isEmpty()) {
                return new JsonToNBT(new StringReader(nbt)).func_193593_f();
            }
        }
        catch (CommandSyntaxException e) {
            MenuCompanions.LOGGER.warn("Failed to read nbt for entity type {}", (Object)(type != null ? type.func_212546_e().getString() : RANDOM));
        }
        return new CompoundNBT();
    }

    public static void serializeEntityType(JsonObject jsonobject, EntityType<?> value) {
        String id = value != null ? Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(value)).toString() : RANDOM;
        jsonobject.addProperty("id", id);
    }

    @Nullable
    public static EntityType<?> readEntityType(String id) {
        ResourceLocation resourceKey = ResourceLocation.func_208304_a((String)id);
        if (resourceKey != null && ForgeRegistries.ENTITIES.containsKey(resourceKey)) {
            return (EntityType)ForgeRegistries.ENTITIES.getValue(resourceKey);
        }
        return null;
    }

    public static <T extends Enum<T>> void serializeEnum(JsonObject jsonobject, String key, T value) {
        jsonobject.addProperty(key, value.name());
    }

    public static <T extends Enum<T>> T deserializeEnum(JsonObject jsonobject, String key, Class<T> clazz, T defaultValue) {
        if (jsonobject.has(key)) {
            try {
                return Enum.valueOf(clazz, JSONUtils.func_151200_h((JsonObject)jsonobject, (String)key));
            }
            catch (IllegalArgumentException e) {
                MenuCompanions.LOGGER.error("Unable to deserialize enum value: {}", (Object)e.getMessage());
            }
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> void serializeEnumProperties(JsonObject jsonobject, Class<T> clazz, byte data, Function<T, String> key, Function<T, Integer> value) {
        for (Enum constant : (Enum[])clazz.getEnumConstants()) {
            jsonobject.addProperty(key.apply(constant), Boolean.valueOf((data & value.apply(constant)) == value.apply(constant)));
        }
    }

    public static <T extends Enum<T>> byte deserializeEnumProperties(JsonObject jsonobject, Class<T> clazz, Function<T, String> key, Function<T, Integer> value) {
        byte data = 0;
        for (Enum constant : (Enum[])clazz.getEnumConstants()) {
            if (!JSONUtils.func_151212_i((JsonObject)jsonobject, (String)key.apply(constant))) continue;
            data = (byte)(data | value.apply(constant));
        }
        return data;
    }
}

