/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.config;

import com.fuzs.menucompanions.MenuCompanions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.FMLPaths;

public class JSONConfigUtil {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void load(String jsonName, String modId, BiConsumer<String, File> serializer, Consumer<FileReader> deserializer) {
        File jsonFile = JSONConfigUtil.getFilePath(jsonName, modId);
        JSONConfigUtil.createIfAbsent(jsonName, jsonFile, serializer);
        JSONConfigUtil.loadFromFile(jsonName, jsonFile, deserializer);
    }

    private static void createIfAbsent(String jsonName, File jsonFile, BiConsumer<String, File> serializer) {
        if (!jsonFile.exists()) {
            jsonFile.getParentFile().mkdir();
            serializer.accept(jsonName, jsonFile);
        }
    }

    public static void copyToFile(String jsonName, File jsonFile) {
        try (InputStream stream = JSONConfigUtil.class.getResourceAsStream(File.separator + jsonName);){
            int i;
            jsonFile.createNewFile();
            byte[] buffer = new byte[600000];
            FileOutputStream outStream = new FileOutputStream(jsonFile);
            while ((i = stream.read(buffer)) != -1) {
                outStream.write(buffer, 0, i);
            }
            outStream.close();
        }
        catch (Exception e) {
            MenuCompanions.LOGGER.error("Failed to copy {} in config directory: {}", (Object)jsonName, (Object)e);
        }
    }

    public static void saveToFile(String jsonName, File jsonFile, JsonElement jsonelement) {
        try (FileWriter writer = new FileWriter(jsonFile);){
            GSON.toJson(jsonelement, (Appendable)writer);
        }
        catch (Exception e) {
            MenuCompanions.LOGGER.error("Failed to create {} in config directory: {}", (Object)jsonName, (Object)e);
        }
    }

    private static void loadFromFile(String jsonName, File file, Consumer<FileReader> deserializer) {
        try (FileReader reader = new FileReader(file);){
            deserializer.accept(reader);
        }
        catch (Exception e) {
            MenuCompanions.LOGGER.error("Failed to read {} in config directory: {}", (Object)jsonName, (Object)e);
        }
    }

    public static File getFilePath(String jsonName, String modId) {
        return new File(FMLPaths.CONFIGDIR.get().toFile(), modId + File.separator + jsonName);
    }
}

