/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control;

import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.SchematicHologram;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.helpful.FilesHelper;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.palette.PaletteStorage;
import com.simibubi.mightyarchitect.control.phase.ArchitectPhases;
import com.simibubi.mightyarchitect.control.phase.IArchitectPhase;
import com.simibubi.mightyarchitect.control.phase.IDrawBlockHighlights;
import com.simibubi.mightyarchitect.control.phase.IListenForBlockEvents;
import com.simibubi.mightyarchitect.control.phase.IRenderGameOverlay;
import com.simibubi.mightyarchitect.gui.GuiArchitectMenu;
import com.simibubi.mightyarchitect.gui.GuiOpener;
import com.simibubi.mightyarchitect.gui.GuiPalettePicker;
import com.simibubi.mightyarchitect.gui.GuiTextPrompt;
import com.simibubi.mightyarchitect.networking.PacketInstantPrint;
import com.simibubi.mightyarchitect.networking.PacketSender;
import com.simibubi.mightyarchitect.proxy.CombinedClientProxy;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.IOUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ArchitectManager {
    private static ArchitectPhases phase = ArchitectPhases.Empty;
    private static Schematic model = new Schematic();
    private static GuiArchitectMenu menu = new GuiArchitectMenu();

    public static void compose() {
        ArchitectManager.enterPhase(ArchitectPhases.Composing);
    }

    public static void compose(DesignTheme theme) {
        if (ArchitectManager.getModel().getGroundPlan() == null) {
            ArchitectManager.getModel().setGroundPlan(new GroundPlan(theme));
        }
        ArchitectManager.enterPhase(ArchitectPhases.Composing);
    }

    public static void pauseCompose() {
        ArchitectManager.status("Composer paused, use /compose to return.");
    }

    public static void unload() {
        ArchitectManager.enterPhase(ArchitectPhases.Empty);
        ArchitectManager.resetSchematic();
        menu.setVisible(false);
    }

    public static void design() {
        GroundPlan groundPlan = model.getGroundPlan();
        if (groundPlan.isEmpty()) {
            ArchitectManager.status("Draw some rooms before going to the next step!");
            return;
        }
        model.setSketch(groundPlan.theme.getDesignPicker().assembleSketch(groundPlan));
        ArchitectManager.enterPhase(ArchitectPhases.Previewing);
    }

    public static void createPalette(boolean primary) {
        ArchitectManager.getModel().startCreatingNewPalette(primary);
        ArchitectManager.enterPhase(ArchitectPhases.CreatingPalette);
    }

    public static void finishPalette(String name) {
        if (name.isEmpty()) {
            name = "My Palette";
        }
        PaletteDefinition palette = ArchitectManager.getModel().getCreatedPalette();
        palette.setName(name);
        PaletteStorage.exportPalette(palette);
        PaletteStorage.loadAllPalettes();
        ArchitectManager.getModel().applyCreatedPalette();
        ArchitectManager.status("Your new palette has been saved.");
        ArchitectManager.enterPhase(ArchitectPhases.Previewing);
    }

    public static void print() {
        if (ArchitectManager.getModel().getSketch() == null) {
            return;
        }
        for (PacketInstantPrint packet : ArchitectManager.getModel().getPackets()) {
            PacketSender.INSTANCE.sendToServer((IMessage)packet);
        }
        SchematicHologram.reset();
        ArchitectManager.status("Printed result into world.");
        ArchitectManager.unload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToFile(String name) {
        String filepath;
        block8: {
            if (ArchitectManager.getModel().getSketch() == null) {
                return;
            }
            if (name.isEmpty()) {
                name = "My Build";
            }
            String folderPath = "schematics";
            FilesHelper.createFolderIfMissing(folderPath);
            String filename = FilesHelper.findFirstValidFilename(name, folderPath, "nbt");
            filepath = folderPath + "/" + filename;
            OutputStream outputStream = null;
            try {
                outputStream = Files.newOutputStream(Paths.get(filepath, new String[0]), StandardOpenOption.CREATE);
                NBTTagCompound nbttagcompound = ArchitectManager.getModel().writeToTemplate().writeToNBT(new NBTTagCompound());
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)outputStream);
                if (outputStream == null) break block8;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block8;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            break block8;
            finally {
                if (outputStream != null) {
                    IOUtils.closeQuietly(outputStream);
                }
            }
        }
        ArchitectManager.status("Saved as " + filepath);
    }

    public static void status(String message) {
        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(message), true);
    }

    public static void pickPalette() {
        if (ArchitectManager.getModel().getSketch() == null) {
            return;
        }
        if (ArchitectManager.inPhase(ArchitectPhases.CreatingPalette)) {
            ArchitectManager.getModel().stopPalettePreview();
            ArchitectManager.enterPhase(ArchitectPhases.Previewing);
        }
        GuiOpener.open(new GuiPalettePicker());
    }

    public static boolean inPhase(ArchitectPhases phase) {
        return ArchitectManager.phase == phase;
    }

    public static void enterPhase(ArchitectPhases newPhase) {
        IArchitectPhase phaseHandler = phase.getPhaseHandler();
        phaseHandler.whenExited();
        phaseHandler = newPhase.getPhaseHandler();
        phaseHandler.whenEntered();
        phase = newPhase;
        menu.updateContents();
    }

    public static Schematic getModel() {
        return model;
    }

    public static ArchitectPhases getPhase() {
        return phase;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            phase.getPhaseHandler().update();
        }
        menu.onClientTick();
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            phase.getPhaseHandler().render();
        }
    }

    @SubscribeEvent
    public static void onRightClick(MouseEvent event) {
        if (event.isButtonstate() && Mouse.isButtonDown((int)event.getButton())) {
            phase.getPhaseHandler().onClick(event.getButton());
        }
    }

    @SubscribeEvent
    public static void onKeyTyped(InputEvent.KeyInputEvent event) {
        if (!Keyboard.getEventKeyState()) {
            return;
        }
        if (CombinedClientProxy.COMPOSE.func_151468_f()) {
            if (menu.func_193976_p()) {
                return;
            }
            menu.updateContents();
            GuiOpener.open(menu);
            menu.func_193975_a(true);
            menu.setVisible(true);
            return;
        }
        phase.getPhaseHandler().onKey(Keyboard.getEventKey());
    }

    @SubscribeEvent
    public static void onBlockPlaced(PlayerInteractEvent.RightClickBlock event) {
        IArchitectPhase phaseHandler;
        if (event.getItemStack() == ItemStack.field_190927_a) {
            return;
        }
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof ItemBlock && (phaseHandler = phase.getPhaseHandler()) instanceof IListenForBlockEvents) {
            Vec3d hitVec = event.getHitVec();
            IBlockState stateForPlacement = ((ItemBlock)item).func_179223_d().getStateForPlacement(event.getWorld(), event.getPos(), event.getFace(), (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, event.getItemStack().func_77960_j(), (EntityLivingBase)event.getEntityPlayer(), event.getHand());
            ((IListenForBlockEvents)((Object)phaseHandler)).onBlockPlaced(event.getPos().func_177972_a(event.getFace()), stateForPlacement);
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(PlayerInteractEvent.LeftClickBlock event) {
        IArchitectPhase phaseHandler = phase.getPhaseHandler();
        if (phaseHandler instanceof IListenForBlockEvents) {
            ((IListenForBlockEvents)((Object)phaseHandler)).onBlockBroken(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        IArchitectPhase phaseHandler = phase.getPhaseHandler();
        if (phaseHandler instanceof IDrawBlockHighlights) {
            ((IDrawBlockHighlights)((Object)phaseHandler)).onBlockHighlight(event);
        }
    }

    @SubscribeEvent
    public static void onDrawGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        IArchitectPhase phaseHandler = phase.getPhaseHandler();
        if (phaseHandler instanceof IRenderGameOverlay) {
            ((IRenderGameOverlay)((Object)phaseHandler)).renderGameOverlay(event);
        }
        menu.drawPassive();
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickBlock event) {
    }

    public static void resetSchematic() {
        model = new Schematic();
    }

    public static boolean handleMenuInput(int key, char character) {
        switch (phase) {
            case Composing: {
                if (character == 'f') {
                    ArchitectManager.design();
                    return true;
                }
                if (character == 'u') {
                    ArchitectManager.unload();
                    return true;
                }
            }
            case CreatingPalette: {
                if (character == 'f') {
                    GuiTextPrompt gui = new GuiTextPrompt(result -> ArchitectManager.finishPalette(result), result -> {});
                    gui.setButtonTextConfirm("Save and Apply");
                    gui.setButtonTextAbort("Cancel");
                    gui.setTitle("Enter a name for your Palette:");
                    GuiOpener.open(gui);
                    return true;
                }
                if (character == 'r') {
                    ArchitectManager.pickPalette();
                    return true;
                }
                if (character == 'u') {
                    ArchitectManager.unload();
                    return true;
                }
            }
            case Editing: {
                break;
            }
            case Empty: {
                if (character == 'c') {
                    ArchitectManager.unload();
                    return true;
                }
                int ordinal = character - 49;
                if (ordinal < DesignTheme.values().length && ordinal >= 0) {
                    ArchitectManager.compose(DesignTheme.values()[ordinal]);
                    return true;
                }
                return false;
            }
            case Previewing: {
                if (character == 'c') {
                    ArchitectManager.pickPalette();
                    return true;
                }
                if (character == 'r') {
                    ArchitectManager.design();
                    return false;
                }
                if (character == 'e') {
                    ArchitectManager.compose();
                    return true;
                }
                if (character == 's') {
                    GuiTextPrompt gui = new GuiTextPrompt(result -> ArchitectManager.writeToFile(result), result -> {});
                    gui.setButtonTextConfirm("Save Schematic");
                    gui.setButtonTextAbort("Cancel");
                    gui.setTitle("Enter a name for your Build:");
                    GuiOpener.open(gui);
                    return true;
                }
                if (character == 'p') {
                    if (!Minecraft.func_71410_x().func_71356_B()) {
                        return false;
                    }
                    ArchitectManager.print();
                    return true;
                }
                if (character != 'u') break;
                ArchitectManager.unload();
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> getKeybinds() {
        HashMap<String, String> keybinds = new HashMap<String, String>();
        switch (phase) {
            case Composing: {
                keybinds.put("U", "Unload");
                keybinds.put("F", "Finish");
                break;
            }
            case CreatingPalette: {
                keybinds.put("U", "Unload");
                keybinds.put("R", "Return to Picker");
                keybinds.put("F", "Save Palette");
                break;
            }
            case Editing: {
                break;
            }
            case Empty: {
                for (DesignTheme theme : DesignTheme.values()) {
                    keybinds.put("" + (theme.ordinal() + 1), theme.getDisplayName());
                }
                keybinds.put("...", "More Themes coming!");
                keybinds.put("C", "Cancel");
                break;
            }
            case Previewing: {
                keybinds.put("C", "Choose a Palette");
                keybinds.put("R", "Re-Roll Designs");
                keybinds.put("E", "Edit Ground Plan");
                keybinds.put("S", "Save as Schematic");
                if (Minecraft.func_71410_x().func_71356_B()) {
                    keybinds.put("P", "Print blocks into world");
                }
                keybinds.put("U", "Unload");
                break;
            }
        }
        return keybinds;
    }
}

