/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control;

import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.TemplateBlockAccess;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class SchematicHologram {
    private static final RegionRenderCacheBuilder bufferCache = new RegionRenderCacheBuilder();
    private static final boolean[] usedBlockRenderLayers = new boolean[BlockRenderLayer.values().length];
    private static final boolean[] startedBufferBuilders = new boolean[BlockRenderLayer.values().length];
    private static SchematicHologram instance;
    private boolean active;
    private boolean changed;
    private Schematic schematic;

    public SchematicHologram() {
        instance = this;
        this.changed = false;
    }

    public void startHologram(Schematic schematic) {
        this.schematic = schematic;
        this.active = true;
        this.changed = true;
    }

    public static SchematicHologram getInstance() {
        return instance;
    }

    public static void display(Schematic schematic) {
        instance = new SchematicHologram();
        instance.startHologram(schematic);
    }

    public static void reset() {
        instance = null;
    }

    public void schematicChanged() {
        this.changed = true;
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (instance != null && SchematicHologram.instance.active) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (minecraft.field_71441_e == null) {
                return;
            }
            if (minecraft.field_71439_g == null) {
                return;
            }
            if (SchematicHologram.instance.changed) {
                SchematicHologram.redraw(minecraft);
                SchematicHologram.instance.changed = false;
            }
        }
    }

    private static void redraw(Minecraft minecraft) {
        TemplateBlockAccess materializedSketch;
        Arrays.fill(usedBlockRenderLayers, false);
        Arrays.fill(startedBufferBuilders, false);
        Schematic schematic = SchematicHologram.instance.schematic;
        TemplateBlockAccess blockAccess = materializedSketch = (TemplateBlockAccess)schematic.getMaterializedSketch();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        LinkedList<IBlockState> blockstates = new LinkedList<IBlockState>();
        for (BlockPos localPos : materializedSketch.getAllPositions()) {
            BlockPos pos = localPos.func_177971_a((Vec3i)schematic.getAnchor());
            IBlockState state = blockAccess.func_180495_p(pos);
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                if (!state.func_177230_c().canRenderInLayer(state, blockRenderLayer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)blockRenderLayer);
                int blockRenderLayerId = blockRenderLayer.ordinal();
                BufferBuilder bufferBuilder = bufferCache.func_179039_a(blockRenderLayerId);
                if (!startedBufferBuilders[blockRenderLayerId]) {
                    SchematicHologram.startedBufferBuilders[blockRenderLayerId] = true;
                    bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                }
                int n = blockRenderLayerId;
                usedBlockRenderLayers[n] = usedBlockRenderLayers[n] | blockRendererDispatcher.func_175018_a(state, pos, (IBlockAccess)blockAccess, bufferBuilder);
                blockstates.add(state);
            }
            ForgeHooksClient.setRenderLayer(null);
        }
        for (int blockRenderLayerId = 0; blockRenderLayerId < usedBlockRenderLayers.length; ++blockRenderLayerId) {
            if (!startedBufferBuilders[blockRenderLayerId]) continue;
            bufferCache.func_179039_a(blockRenderLayerId).func_178977_d();
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (instance != null && SchematicHologram.instance.active) {
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            if (entity == null) {
                return;
            }
            float partialTicks = event.getPartialTicks();
            double renderPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double renderPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double renderPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            for (int blockRenderLayerId = 0; blockRenderLayerId < usedBlockRenderLayers.length; ++blockRenderLayerId) {
                if (!usedBlockRenderLayers[blockRenderLayerId]) continue;
                BufferBuilder bufferBuilder = bufferCache.func_179039_a(blockRenderLayerId);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
                SchematicHologram.drawBuffer(bufferBuilder);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
        }
    }

    private static void drawBuffer(BufferBuilder bufferBuilder) {
        if (bufferBuilder.func_178989_h() > 0) {
            VertexFormatElement.EnumUsage usage;
            VertexFormatElement vertexformatelement;
            int index;
            VertexFormat vertexformat = bufferBuilder.func_178973_g();
            int size = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = bufferBuilder.func_178966_f();
            List list = vertexformat.func_177343_g();
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                usage = vertexformatelement.func_177375_c();
                bytebuffer.position(vertexformat.func_181720_d(index));
                usage.preDraw(vertexformat, index, size, bytebuffer);
            }
            GlStateManager.func_187439_f((int)bufferBuilder.func_178979_i(), (int)0, (int)bufferBuilder.func_178989_h());
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                usage = vertexformatelement.func_177375_c();
                usage.postDraw(vertexformat, index, size, bytebuffer);
            }
        }
    }
}

