/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Template {
    private final List<BlockInfo> blocks = Lists.newArrayList();
    private BlockPos size = BlockPos.field_177992_a;
    private String author = "?";

    public BlockPos getSize() {
        return this.size;
    }

    public void setSize(BlockPos size) {
        this.size = size;
    }

    public void setAuthor(String authorIn) {
        this.author = authorIn;
    }

    public String getAuthor() {
        return this.author;
    }

    public void putBlock(BlockPos pos, IBlockState state) {
        this.blocks.add(new BlockInfo(pos, state, null));
    }

    public List<BlockInfo> getBlocks() {
        return this.blocks;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist = new NBTTagList();
        for (BlockInfo template$blockinfo : this.blocks) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("pos", (NBTBase)this.writeInts(template$blockinfo.pos.func_177958_n(), template$blockinfo.pos.func_177956_o(), template$blockinfo.pos.func_177952_p()));
            nbttagcompound.func_74768_a("state", template$basicpalette.idFor(template$blockinfo.blockState));
            if (template$blockinfo.tileentityData != null) {
                nbttagcompound.func_74782_a("nbt", (NBTBase)template$blockinfo.tileentityData);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBTTagList nbttaglist2 = new NBTTagList();
        for (IBlockState iblockstate : template$basicpalette) {
            nbttaglist2.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)iblockstate));
        }
        FMLCommonHandler.instance().getDataFixer().writeVersionData(nbt);
        nbt.func_74782_a("palette", (NBTBase)nbttaglist2);
        nbt.func_74782_a("blocks", (NBTBase)nbttaglist);
        nbt.func_74782_a("size", (NBTBase)this.writeInts(this.size.func_177958_n(), this.size.func_177956_o(), this.size.func_177952_p()));
        nbt.func_74778_a("author", this.author);
        nbt.func_74768_a("DataVersion", 1343);
        return nbt;
    }

    public void read(NBTTagCompound compound) {
        this.blocks.clear();
        NBTTagList nbttaglist = compound.func_150295_c("size", 3);
        this.size = new BlockPos(nbttaglist.func_186858_c(0), nbttaglist.func_186858_c(1), nbttaglist.func_186858_c(2));
        this.author = compound.func_74779_i("author");
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist1 = compound.func_150295_c("palette", 10);
        for (int i = 0; i < nbttaglist1.func_74745_c(); ++i) {
            template$basicpalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)nbttaglist1.func_150305_b(i)), i);
        }
        NBTTagList nbttaglist3 = compound.func_150295_c("blocks", 10);
        for (int j = 0; j < nbttaglist3.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist3.func_150305_b(j);
            NBTTagList nbttaglist2 = nbttagcompound.func_150295_c("pos", 3);
            BlockPos blockpos = new BlockPos(nbttaglist2.func_186858_c(0), nbttaglist2.func_186858_c(1), nbttaglist2.func_186858_c(2));
            IBlockState iblockstate = template$basicpalette.stateFor(nbttagcompound.func_74762_e("state"));
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74764_b("nbt") ? nbttagcompound.func_74775_l("nbt") : null;
            this.blocks.add(new BlockInfo(blockpos, iblockstate, nbttagcompound1));
        }
    }

    private NBTTagList writeInts(int ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : values) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        return nbttaglist;
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, PlacementSettings placementIn) {
        this.addBlocksToWorld(worldIn, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, placementIn), placementIn, 2);
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, PlacementSettings placementIn, int flags) {
        this.addBlocksToWorld(worldIn, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, placementIn), placementIn, flags);
    }

    public void addBlocksToWorld(World worldIn, BlockPos origin, @Nullable ITemplateProcessor templateProcessor, PlacementSettings placementIn, int flags) {
        if (!this.blocks.isEmpty() && this.size.func_177958_n() >= 1 && this.size.func_177956_o() >= 1 && this.size.func_177952_p() >= 1) {
            Block block = placementIn.func_186219_f();
            StructureBoundingBox structureboundingbox = placementIn.func_186213_g();
            for (BlockInfo template$blockinfo : this.blocks) {
                TileEntity tileentity2;
                TileEntity tileentity;
                Template.BlockInfo blockInfoVanillaProcessed;
                BlockPos blockpos = Template.transformedBlockPos(placementIn, template$blockinfo.pos).func_177971_a((Vec3i)origin);
                if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                Template.BlockInfo blockInfoVanilla = new Template.BlockInfo(template$blockinfo.pos, template$blockinfo.blockState, template$blockinfo.tileentityData);
                Template.BlockInfo blockInfo = blockInfoVanillaProcessed = templateProcessor != null ? templateProcessor.func_189943_a(worldIn, blockpos, blockInfoVanilla) : blockInfoVanilla;
                BlockInfo template$blockinfo1 = new BlockInfo(blockInfoVanillaProcessed.field_186242_a, blockInfoVanillaProcessed.field_186243_b, blockInfoVanillaProcessed.field_186244_c);
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.blockState.func_177230_c();
                if (block != null && block == block1 || placementIn.func_186227_h() && block1 == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                IBlockState iblockstate = template$blockinfo1.blockState.func_185902_a(placementIn.func_186212_b());
                IBlockState iblockstate1 = iblockstate.func_185907_a(placementIn.func_186215_c());
                if (template$blockinfo1.tileentityData != null && (tileentity = worldIn.func_175625_s(blockpos)) != null) {
                    if (tileentity instanceof IInventory) {
                        ((IInventory)tileentity).func_174888_l();
                    }
                    worldIn.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 4);
                }
                if (!worldIn.func_180501_a(blockpos, iblockstate1, flags) || template$blockinfo1.tileentityData == null || (tileentity2 = worldIn.func_175625_s(blockpos)) == null) continue;
                template$blockinfo1.tileentityData.func_74768_a("x", blockpos.func_177958_n());
                template$blockinfo1.tileentityData.func_74768_a("y", blockpos.func_177956_o());
                template$blockinfo1.tileentityData.func_74768_a("z", blockpos.func_177952_p());
                tileentity2.func_145839_a(template$blockinfo1.tileentityData);
                tileentity2.func_189668_a(placementIn.func_186212_b());
                tileentity2.func_189667_a(placementIn.func_186215_c());
            }
            for (BlockInfo template$blockinfo2 : this.blocks) {
                TileEntity tileentity1;
                if (block != null && block == template$blockinfo2.blockState.func_177230_c()) continue;
                BlockPos blockpos1 = Template.transformedBlockPos(placementIn, template$blockinfo2.pos).func_177971_a((Vec3i)origin);
                if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos1)) continue;
                worldIn.func_175722_b(blockpos1, template$blockinfo2.blockState.func_177230_c(), false);
                if (template$blockinfo2.tileentityData == null || (tileentity1 = worldIn.func_175625_s(blockpos1)) == null) continue;
                tileentity1.func_70296_d();
            }
        }
    }

    private static BlockPos transformedBlockPos(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(k, j, -i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-k, j, i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos;
    }

    public static BlockPos transformedBlockPos(PlacementSettings placementIn, BlockPos pos) {
        return Template.transformedBlockPos(pos, placementIn.func_186212_b(), placementIn.func_186215_c());
    }

    public static class BlockInfo {
        public final BlockPos pos;
        public final IBlockState blockState;
        public final NBTTagCompound tileentityData;

        public BlockInfo(BlockPos posIn, IBlockState stateIn, @Nullable NBTTagCompound compoundIn) {
            this.pos = posIn;
            this.blockState = stateIn;
            this.tileentityData = compoundIn;
        }
    }

    static class BasicPalette
    implements Iterable<IBlockState> {
        public static final IBlockState DEFAULT_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
        final ObjectIntIdentityMap<IBlockState> ids = new ObjectIntIdentityMap(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(IBlockState state) {
            int i = this.ids.func_148747_b((Object)state);
            if (i == -1) {
                i = this.lastId++;
                this.ids.func_148746_a((Object)state, i);
            }
            return i;
        }

        @Nullable
        public IBlockState stateFor(int id) {
            IBlockState iblockstate = (IBlockState)this.ids.func_148745_a(id);
            return iblockstate == null ? DEFAULT_BLOCK_STATE : iblockstate;
        }

        @Override
        public Iterator<IBlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockState p_189956_1_, int p_189956_2_) {
            this.ids.func_148746_a((Object)p_189956_1_, p_189956_2_);
        }
    }
}

