/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose;

import com.simibubi.mightyarchitect.control.compose.Room;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class Cuboid {
    public int x;
    public int y;
    public int z;
    public int width;
    public int height;
    public int length;

    public Cuboid(BlockPos origin, BlockPos size) {
        this(origin, size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
    }

    public Cuboid(BlockPos origin, int width, int height, int length) {
        this.x = origin.func_177958_n() + (width < 0 ? width : 0);
        this.y = origin.func_177956_o() + (height < 0 ? height : 0);
        this.z = origin.func_177952_p() + (length < 0 ? length : 0);
        this.width = Math.abs(width);
        this.height = Math.abs(height);
        this.length = Math.abs(length);
    }

    public BlockPos getOrigin() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public BlockPos getSize() {
        return new BlockPos(this.width, this.height, this.length);
    }

    public Cuboid clone() {
        return new Cuboid(new BlockPos(this.x, this.y, this.z), this.width, this.height, this.length);
    }

    public void move(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void centerHorizontallyOn(BlockPos pos) {
        this.x = pos.func_177958_n() - this.width / 2;
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p() - this.length / 2;
    }

    public boolean intersects(Cuboid other) {
        return other.x < this.x + this.width && other.z < this.z + this.length && other.x + other.width > this.x && other.z + other.length > this.z;
    }

    public boolean contains(BlockPos pos) {
        return pos.func_177958_n() >= this.x && pos.func_177958_n() < this.x + this.width && pos.func_177956_o() >= this.y && pos.func_177956_o() < this.y + this.height && pos.func_177952_p() >= this.z && pos.func_177952_p() < this.z + this.length;
    }

    public BlockPos getCenter() {
        return this.getOrigin().func_177982_a(this.width / 2, this.height / 2, this.length / 2);
    }

    public void moveToAttach(Room other, EnumFacing side, int shift) {
        if (side != EnumFacing.EAST && side != EnumFacing.WEST) {
            this.centerOnOthersX(other, shift);
        }
        if (side != EnumFacing.NORTH && side != EnumFacing.SOUTH) {
            this.centerOnOthersZ(other, shift);
        }
        switch (side) {
            case WEST: {
                this.x = other.x + other.width;
                break;
            }
            case EAST: {
                this.x = other.x - this.width;
                break;
            }
            case SOUTH: {
                this.z = other.z + other.length;
                break;
            }
            case NORTH: {
                this.z = other.z - this.length;
                break;
            }
            case UP: {
                this.y = other.y + other.height;
                break;
            }
            case DOWN: {
                this.y = other.y - this.height;
                break;
            }
        }
    }

    private void centerOnOthersZ(Cuboid other, int shift) {
        this.z = other.z + shift + (other.length - this.length) / 2;
    }

    private void centerOnOthersX(Cuboid other, int shift) {
        this.x = other.x + shift + (other.width - this.width) / 2;
    }
}

