/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose;

import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class Room
extends Cuboid {
    public DesignLayer designLayer;
    public DesignType roofType;
    public char styleGroup = (char)65;
    public boolean secondaryPalette = false;
    public int layer;

    public Room(BlockPos origin, BlockPos size) {
        this(origin, size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
    }

    public Room(BlockPos origin, int width, int height, int length) {
        super(origin, width, height, length);
        this.designLayer = DesignLayer.Regular;
        this.roofType = DesignType.ROOF;
    }

    @Override
    public Room clone() {
        Room clone = new Room(this.getOrigin(), this.getSize());
        clone.styleGroup = this.styleGroup;
        clone.roofType = this.roofType;
        clone.secondaryPalette = this.secondaryPalette;
        return clone;
    }

    public Room getInterior() {
        Room clone = this.clone();
        ++clone.x;
        ++clone.z;
        clone.width -= 2;
        clone.length -= 2;
        clone.secondaryPalette = this.secondaryPalette;
        return clone;
    }

    public Room stack() {
        Room clone = this.clone();
        clone.y += this.height;
        this.roofType = DesignType.NONE;
        return clone;
    }

    public EnumFacing.Axis getOrientation() {
        return this.width > this.length ? EnumFacing.Axis.X : EnumFacing.Axis.Z;
    }
}

