/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose;

import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;

public class Stack {
    public static final int MaxHeight = 5;
    private List<Room> rooms = new ArrayList<Room>();

    public Stack(Room room) {
        if (room.designLayer == DesignLayer.None) {
            room.designLayer = DesignLayer.Foundation;
        }
        this.rooms.add(room);
    }

    public Room lowest() {
        if (this.rooms.isEmpty()) {
            return null;
        }
        return this.rooms.get(0);
    }

    public Room highest() {
        if (this.rooms.isEmpty()) {
            return null;
        }
        return this.rooms.get(this.rooms.size() - 1);
    }

    public void increase() {
        if (this.rooms.size() < 5) {
            Room newRoom = this.highest().stack();
            if (this.highest().designLayer == DesignLayer.Foundation) {
                newRoom.designLayer = DesignLayer.Regular;
                newRoom.height = Math.max(this.highest().height, 4);
            }
            this.rooms.add(newRoom);
        }
    }

    public void decrease() {
        if (!this.rooms.isEmpty()) {
            this.rooms.remove(this.highest());
        }
    }

    public void forEachAbove(Room anchor, Consumer<? super Room> action) {
        this.rooms.subList(this.rooms.indexOf(anchor) + 1, this.rooms.size()).forEach(action);
    }

    public void forRoomAndEachAbove(Room anchor, Consumer<? super Room> action) {
        this.rooms.subList(this.rooms.indexOf(anchor), this.rooms.size()).forEach(action);
    }

    public void forEach(Consumer<? super Room> action) {
        this.rooms.forEach(action);
    }

    public Room getRoomAtPos(BlockPos localPos) {
        for (Room room : this.rooms) {
            if (!room.contains(localPos)) continue;
            return room;
        }
        return null;
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    public int floors() {
        return this.rooms.size();
    }

    public int getMaxFacadeWidth() {
        return 35;
    }

    public int getMinWidth() {
        return 5;
    }
}

