/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.planner.RoomTool;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.helpful.RaycastHelper;
import com.simibubi.mightyarchitect.control.helpful.TesselatorTextures;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;

public class CylinderRoomTool
extends RoomTool {
    @Override
    public void init() {
        super.init();
        this.firstPosition = null;
    }

    @Override
    public void updateSelection() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.transparentStacks.clear();
        RayTraceResult trace = RaycastHelper.rayTraceRange(player.field_70170_p, (EntityPlayer)player, 75.0);
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos hit = trace.func_178782_a();
            this.makeStacksTransparent(player, hit);
            if (trace.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) {
                hit = hit.func_177972_a(trace.field_178784_b);
            }
            this.selectedPosition = this.model.getAnchor() == null ? hit : hit.func_177973_b((Vec3i)this.model.getAnchor());
        } else {
            this.selectedPosition = null;
        }
        if (this.firstPosition == null) {
            return;
        }
        if (this.selectedPosition == null) {
            return;
        }
    }

    @Override
    protected String createRoom(GroundPlan groundPlan) {
        int distance = (int)Math.sqrt(this.firstPosition.func_177951_i((Vec3i)this.selectedPosition));
        distance = Math.min(distance, 5);
        BlockPos size = new BlockPos(distance * 2, 0, distance * 2);
        Room room = new Room(this.firstPosition, size);
        ++room.width;
        ++room.length;
        room.x -= distance;
        room.z -= distance;
        room.height = 2;
        room.designLayer = DesignLayer.Foundation;
        int radius = (room.width - 1) / 2;
        if (room.width != room.length) {
            return "\u00ef\u00bf\u00bdcSelection is not a circle: " + room.width + " != " + room.length;
        }
        if ((double)(room.width % 2) == 0.0) {
            return "\u00ef\u00bf\u00bdcTower cannot have even diameter: " + room.width;
        }
        if (radius < 2) {
            return "\u00ef\u00bf\u00bdcTower is too Thin (<2): " + radius;
        }
        if (radius > 5) {
            return "\u00ef\u00bf\u00bdcTower radius is too large (>5): " + radius;
        }
        room.roofType = DesignType.ROOF;
        this.lastAddedStack = new CylinderStack(room);
        groundPlan.addStack(this.lastAddedStack);
        this.firstPosition = null;
        return "\u00ef\u00bf\u00bdaNew Tower has been added";
    }

    @Override
    public void renderTool() {
        if (this.selectedPosition == null) {
            return;
        }
        BlockPos anchor = ArchitectManager.getModel().getAnchor();
        BlockPos selectedPos = anchor != null ? this.selectedPosition.func_177971_a((Vec3i)anchor) : this.selectedPosition;
        BlockPos firstPos = this.firstPosition != null ? this.firstPosition.func_177971_a((Vec3i)anchor) : null;
        TesselatorTextures.Selection.bind();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TessellatorHelper.walls(bufferBuilder, selectedPos, new BlockPos(1, 1, 1), 0.125, false, true);
        if (firstPos != null) {
            int distance = (int)Math.sqrt(this.firstPosition.func_177951_i((Vec3i)this.selectedPosition));
            distance = Math.min(distance, 5);
            BlockPos size = new BlockPos(distance * 2, 0, distance * 2);
            Cuboid selection = new Cuboid(firstPos, size.func_177958_n(), 1, size.func_177952_p());
            ++selection.width;
            ++selection.length;
            selection.x -= distance;
            selection.z -= distance;
            TessellatorHelper.walls(bufferBuilder, selection.getOrigin(), selection.getSize(), -0.125, false, true);
            Tessellator.func_178181_a().func_78381_a();
            TessellatorHelper.drawString("" + selection.width, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z - 1, true, false);
            TessellatorHelper.drawString("" + selection.width, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z + selection.length + 1, true, false);
            TessellatorHelper.drawString("" + selection.length, selection.x + selection.width + 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, true, false);
            TessellatorHelper.drawString("" + selection.length, selection.x - 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, true, false);
        } else {
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

