/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.ImAToolForGroundPlanning;
import com.simibubi.mightyarchitect.control.helpful.RaycastHelper;
import com.simibubi.mightyarchitect.control.helpful.TesselatorTextures;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;

public abstract class GroundPlanningToolBase
implements ImAToolForGroundPlanning {
    protected Schematic model;
    protected BlockPos selectedPosition;
    protected Set<Stack> transparentStacks;

    @Override
    public void init() {
        this.model = ArchitectManager.getModel();
        this.selectedPosition = null;
        this.transparentStacks = new HashSet<Stack>();
    }

    @Override
    public void updateSelection() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.transparentStacks.clear();
        RayTraceResult trace = RaycastHelper.rayTraceRange(player.field_70170_p, (EntityPlayer)player, 75.0);
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos hit = trace.func_178782_a();
            this.makeStacksTransparent(player, hit);
            if (trace.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) {
                hit = hit.func_177972_a(trace.field_178784_b);
            }
            this.selectedPosition = this.model.getAnchor() == null ? hit : hit.func_177973_b((Vec3i)this.model.getAnchor());
        } else {
            this.selectedPosition = null;
        }
    }

    protected void makeStacksTransparent(EntityPlayerSP player, BlockPos hit) {
        if (!this.model.getGroundPlan().isEmpty()) {
            BlockPos target = hit;
            RaycastHelper.rayTraceUntil((EntityPlayer)player, 75.0, pos -> {
                BlockPos localPos = pos.func_177973_b((Vec3i)this.model.getAnchor());
                this.model.getGroundPlan().forEachStack(stack -> {
                    if (stack.getRoomAtPos(localPos) != null) {
                        this.transparentStacks.add((Stack)stack);
                    }
                });
                return pos.equals((Object)target);
            });
        }
    }

    @Override
    public String handleRightClick() {
        if (this.selectedPosition == null) {
            return null;
        }
        if (this.model.getAnchor() == null) {
            this.model.setAnchor(this.selectedPosition);
            this.selectedPosition = BlockPos.field_177992_a;
        }
        return null;
    }

    @Override
    public void handleKey(int key) {
    }

    @Override
    public void renderGroundPlan() {
        GroundPlan groundPlan = this.model.getGroundPlan();
        BlockPos anchor = this.model.getAnchor();
        if (groundPlan != null && anchor != null) {
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            TesselatorTextures.Trim.bind();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            groundPlan.forEachStack(stack -> stack.forEach(room -> {
                BlockPos pos = room.getOrigin().func_177971_a((Vec3i)anchor);
                TessellatorHelper.walls(bufferBuilder, pos, new BlockPos(room.width, 1, room.length), 0.125, false, true);
                if (room == stack.highest()) {
                    TessellatorHelper.walls(bufferBuilder, pos.func_177982_a(0, room.height, 0), new BlockPos(room.width, 1, room.length), 0.125, false, true);
                }
            }));
            Tessellator.func_178181_a().func_78381_a();
            groundPlan.forEachStack(stack -> {
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                if (this.transparentStacks.contains(stack)) {
                    TesselatorTextures.RoomTransparent.bind();
                } else {
                    TesselatorTextures.Room.bind();
                }
                stack.forEach(room -> {
                    BlockPos pos = room.getOrigin().func_177971_a((Vec3i)anchor);
                    if (room == stack.highest()) {
                        TessellatorHelper.cube(bufferBuilder, pos, room.getSize(), 0.0, false, false);
                    } else {
                        TessellatorHelper.walls(bufferBuilder, pos, room.getSize(), 0.0, false, false);
                    }
                });
                Tessellator.func_178181_a().func_78381_a();
            });
        }
    }
}

