/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.GroundPlanningToolBase;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.helpful.TesselatorTextures;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class RoomTool
extends GroundPlanningToolBase {
    protected BlockPos firstPosition;
    protected Stack lastAddedStack;

    @Override
    public void init() {
        super.init();
        this.firstPosition = null;
    }

    @Override
    public String handleRightClick() {
        super.handleRightClick();
        if (this.selectedPosition == null) {
            return null;
        }
        if (this.firstPosition == null) {
            this.firstPosition = this.selectedPosition;
            return "First position marked";
        }
        return this.createRoom(ArchitectManager.getModel().getGroundPlan());
    }

    protected String createRoom(GroundPlan groundPlan) {
        Room room = new Room(this.firstPosition, this.selectedPosition.func_177973_b((Vec3i)this.firstPosition));
        ++room.width;
        ++room.length;
        room.height = 2;
        room.designLayer = DesignLayer.Foundation;
        int facadeWidth = Math.min(room.width, room.length);
        if (facadeWidth % 2 == 0) {
            return "\u00ef\u00bf\u00bdcFacade cannot have even width: " + facadeWidth;
        }
        if (facadeWidth < 5) {
            return "\u00ef\u00bf\u00bdcFacade is too narrow (<5): " + facadeWidth;
        }
        if (facadeWidth > 35) {
            return "\u00ef\u00bf\u00bdcFacade is too wide (>25): " + facadeWidth;
        }
        room.roofType = facadeWidth > 15 ? DesignType.FLAT_ROOF : DesignType.ROOF;
        this.lastAddedStack = new Stack(room);
        groundPlan.addStack(this.lastAddedStack);
        this.firstPosition = null;
        return "\u00ef\u00bf\u00bdaNew Room has been added";
    }

    @Override
    public void handleKey(int key) {
        if (this.lastAddedStack == null) {
            return;
        }
        switch (key) {
            case 200: {
                this.lastAddedStack.increase();
                break;
            }
            case 208: {
                this.lastAddedStack.decrease();
                if (this.lastAddedStack.floors() != 0) break;
                ArchitectManager.getModel().getGroundPlan().remove(this.lastAddedStack);
                this.lastAddedStack = null;
            }
        }
    }

    @Override
    public void updateSelection() {
        super.updateSelection();
        if (this.firstPosition == null) {
            return;
        }
        if (this.selectedPosition == null) {
            return;
        }
        BlockPos size = this.selectedPosition.func_177973_b((Vec3i)this.firstPosition);
        if (size.func_177958_n() % 2 != 0) {
            this.selectedPosition = this.selectedPosition.func_177965_g(size.func_177958_n() > 0 ? 1 : -1);
        }
        if (size.func_177952_p() % 2 != 0) {
            this.selectedPosition = this.selectedPosition.func_177970_e(size.func_177952_p() > 0 ? 1 : -1);
        }
    }

    @Override
    public void renderTool() {
        if (this.selectedPosition == null) {
            return;
        }
        BlockPos anchor = ArchitectManager.getModel().getAnchor();
        BlockPos selectedPos = anchor != null ? this.selectedPosition.func_177971_a((Vec3i)anchor) : this.selectedPosition;
        BlockPos firstPos = this.firstPosition != null ? this.firstPosition.func_177971_a((Vec3i)anchor) : null;
        TesselatorTextures.Selection.bind();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TessellatorHelper.walls(bufferBuilder, selectedPos, new BlockPos(1, 1, 1), 0.125, false, true);
        if (firstPos != null) {
            BlockPos size = selectedPos.func_177973_b((Vec3i)firstPos);
            Cuboid selection = new Cuboid(firstPos, size.func_177958_n(), 1, size.func_177952_p());
            ++selection.width;
            ++selection.length;
            TessellatorHelper.walls(bufferBuilder, selection.getOrigin(), selection.getSize(), -0.125, false, true);
            Tessellator.func_178181_a().func_78381_a();
            TessellatorHelper.drawString("" + selection.width, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z - 1, true, false);
            TessellatorHelper.drawString("" + selection.width, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z + selection.length + 1, true, false);
            TessellatorHelper.drawString("" + selection.length, selection.x + selection.width + 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, true, false);
            TessellatorHelper.drawString("" + selection.length, selection.x - 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, true, false);
        } else {
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

