/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.GroundPlanningToolBase;
import com.simibubi.mightyarchitect.control.helpful.RaycastHelper;
import com.simibubi.mightyarchitect.control.helpful.TesselatorTextures;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.gui.GuiComposer;
import com.simibubi.mightyarchitect.gui.GuiOpener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class SelectionTool
extends GroundPlanningToolBase {
    private Stack selectedStack;

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void updateSelection() {
        GroundPlan groundPlan = ArchitectManager.getModel().getGroundPlan();
        BlockPos anchor = ArchitectManager.getModel().getAnchor();
        if (groundPlan.isEmpty()) {
            this.selectedStack = null;
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((EntityPlayer)player, 70.0, position -> groundPlan.getRoomAtPos(position.func_177973_b((Vec3i)anchor)) != null);
        if (result.missed()) {
            this.selectedStack = null;
            return;
        }
        this.selectedStack = groundPlan.getStackAtPos(result.getPos().func_177973_b((Vec3i)anchor));
    }

    @Override
    public String handleRightClick() {
        if (this.selectedStack == null) {
            return "Point at the room to modify";
        }
        GuiOpener.open(new GuiComposer(this.selectedStack));
        return null;
    }

    @Override
    public void renderTool() {
        if (this.selectedStack == null) {
            return;
        }
        TesselatorTextures.SelectedRoom.bind();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.selectedStack.forEach(room -> {
            BlockPos pos = room.getOrigin().func_177971_a((Vec3i)ArchitectManager.getModel().getAnchor());
            TessellatorHelper.cube(bufferBuilder, pos, room.getSize(), 0.0625, true, true);
        });
        Tessellator.func_178181_a().func_78381_a();
    }
}

