/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.block.AllBlocks;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignSlice;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.partials.Wall;
import com.simibubi.mightyarchitect.control.helpful.FilesHelper;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.networking.PacketPlaceSign;
import com.simibubi.mightyarchitect.networking.PacketSender;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DesignExporter {
    public static String exportDesign(World worldIn, BlockPos anchor, ItemStack exporter) {
        NBTTagCompound itemTag = exporter.func_77978_p();
        DesignTheme theme = DesignTheme.valueOf(itemTag.func_74779_i("Theme"));
        DesignType type = DesignType.valueOf(itemTag.func_74779_i("Type"));
        DesignLayer layer = DesignLayer.valueOf(itemTag.func_74779_i("Layer"));
        BlockPos layerDefAnchor = anchor;
        boolean found = false;
        block6: for (int range = 1; range < 100 && !found; ++range) {
            for (int i = 0; i < range; ++i) {
                if (DesignExporter.isMarker(worldIn, anchor.func_177982_a(range, 0, i))) {
                    layerDefAnchor = anchor.func_177982_a(range, 0, i);
                    found = true;
                    continue block6;
                }
                if (!DesignExporter.isMarker(worldIn, anchor.func_177982_a(i, 0, range))) continue;
                layerDefAnchor = anchor.func_177982_a(i, 0, range);
                found = true;
                continue block6;
            }
        }
        if (found) {
            int height = 0;
            BlockPos pos = layerDefAnchor;
            while (DesignExporter.isMarker(worldIn, pos)) {
                ++height;
                pos = pos.func_177984_a();
            }
            BlockPos size = layerDefAnchor.func_177976_e().func_177973_b((Vec3i)anchor.func_177974_f()).func_177982_a(1, height, 1);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("Size", (NBTBase)NBTUtil.func_186859_a((BlockPos)size));
            NBTTagList layers = new NBTTagList();
            HashMap scanMap = new HashMap();
            PaletteDefinition.defaultPalette().getDefinition().forEach((palette, block) -> scanMap.put(block, palette));
            for (int y = 0; y < size.func_177956_o(); ++y) {
                NBTTagCompound layerTag = new NBTTagCompound();
                DesignSlice.DesignSliceTrait trait = DesignSlice.DesignSliceTrait.values()[DesignExporter.markerValueAt(worldIn, layerDefAnchor.func_177981_b(y))];
                layerTag.func_74778_a("Trait", trait.name());
                StringBuilder data = new StringBuilder();
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    for (int x = 0; x < size.func_177958_n(); ++x) {
                        Palette block2 = (Palette)((Object)scanMap.get(worldIn.func_180495_p(anchor.func_177974_f().func_177982_a(x, y, z))));
                        data.append(block2 != null ? (char)block2.asChar() : (char)' ');
                    }
                    if (z >= size.func_177952_p() - 1) continue;
                    data.append(",");
                }
                layerTag.func_74778_a("Blocks", data.toString());
                layers.func_74742_a((NBTBase)layerTag);
            }
            compound.func_74782_a("Layers", (NBTBase)layers);
            if (itemTag.func_74764_b("Additional")) {
                int data = itemTag.func_74762_e("Additional");
                switch (type) {
                    case ROOF: {
                        compound.func_74768_a("Roofspan", data);
                        break;
                    }
                    case FLAT_ROOF: {
                        compound.func_74768_a("Margin", data);
                        break;
                    }
                    case WALL: {
                        compound.func_74778_a("ExpandBehaviour", Wall.ExpandBehaviour.values()[data].name());
                        break;
                    }
                    case TOWER_FLAT_ROOF: 
                    case TOWER_ROOF: 
                    case TOWER: {
                        compound.func_74768_a("Radius", data);
                        break;
                    }
                }
            }
            String basePath = "designs";
            FilesHelper.createFolderIfMissing(basePath);
            String themePath = basePath + "/" + theme.getFilePath();
            FilesHelper.createFolderIfMissing(themePath);
            String layerPath = themePath + "/" + layer.getFilePath();
            FilesHelper.createFolderIfMissing(layerPath);
            String typePath = layerPath + "/" + type.getFilePath();
            FilesHelper.createFolderIfMissing(typePath);
            String filename = "";
            String designPath = "";
            BlockPos signPos = anchor.func_177984_a();
            if (worldIn.func_180495_p(signPos).func_177230_c() == Blocks.field_150472_an) {
                TileEntitySign sign = (TileEntitySign)worldIn.func_175625_s(signPos);
                filename = sign.field_145915_a[1].func_150260_c();
                designPath = typePath + "/" + filename;
            } else {
                for (int index = 0; index < 2048; ++index) {
                    filename = "design" + (index == 0 ? "" : "_" + index) + ".json";
                    designPath = typePath + "/" + filename;
                    if (TheMightyArchitect.class.getClassLoader().getResource(designPath) == null && !Files.exists(Paths.get(designPath, new String[0]), new LinkOption[0])) break;
                }
            }
            PacketSender.INSTANCE.sendToServer((IMessage)new PacketPlaceSign(filename, signPos));
            FilesHelper.saveTagCompoundAsJson(compound, designPath);
            return designPath;
        }
        return "";
    }

    private static boolean isMarker(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == AllBlocks.slice_marker;
    }

    private static int markerValueAt(World worldIn, BlockPos pos) {
        return AllBlocks.slice_marker.func_176201_c(worldIn.func_180495_p(pos));
    }
}

