/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import java.util.Vector;

public class DesignQuery {
    public DesignTheme theme;
    public DesignLayer layer;
    public DesignType type;
    public int desiredWidth;
    public int desiredHeight;

    public DesignQuery(DesignTheme theme, DesignLayer layer, DesignType type) {
        this.theme = theme;
        this.layer = layer;
        this.type = type;
        this.desiredWidth = 0;
        this.desiredHeight = 0;
    }

    public DesignQuery withWidth(int desiredWidth) {
        this.desiredWidth = desiredWidth;
        return this;
    }

    public DesignQuery withHeight(int desiredHeight) {
        this.desiredHeight = desiredHeight;
        return this;
    }

    public boolean isWidthIgnored() {
        return this.desiredWidth == 0;
    }

    public boolean isHeightIgnored() {
        return this.desiredHeight == 0;
    }

    public DesignQuery getClone() {
        return new DesignQuery(this.theme, this.layer, this.type).withWidth(this.desiredWidth).withHeight(this.desiredHeight);
    }

    public Vector<Integer> asCacheKey() {
        Vector<Integer> vector = new Vector<Integer>(4);
        vector.add(this.layer.ordinal());
        vector.add(this.type.ordinal());
        vector.add(this.desiredWidth);
        vector.add(this.desiredHeight);
        return vector;
    }
}

