/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.helpful.FilesHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class DesignResourceLoader {
    private static final String BASE_PATH = "designs";

    public static Map<DesignLayer, Map<DesignType, Set<Design>>> loadDesignsForTheme(DesignTheme theme) {
        HashMap<DesignLayer, Map<DesignType, Set<Design>>> designMap = new HashMap<DesignLayer, Map<DesignType, Set<Design>>>();
        theme.getLayers().forEach(layer -> {
            HashMap typeMap = new HashMap();
            theme.getTypes().forEach(type -> {
                String path = "designs/" + theme.getFilePath() + "/" + layer.getFilePath() + "/" + type.getFilePath();
                typeMap.put(type, DesignResourceLoader.importDesigns(theme, layer, type, path));
            });
            designMap.put((DesignLayer)((Object)layer), typeMap);
        });
        return designMap;
    }

    private static Set<Design> importDesigns(DesignTheme theme, DesignLayer layer, DesignType type, String folderPath) {
        HashSet<Design> designs = new HashSet<Design>();
        for (int index = 0; index < 2048; ++index) {
            String path = folderPath + "/design" + (index == 0 ? "" : "_" + index) + ".json";
            if (TheMightyArchitect.class.getClassLoader().getResource(path) == null) break;
            NBTTagCompound designTag = FilesHelper.loadJsonResourceAsNBT(path);
            designs.add(type.getDesign().fromNBT(designTag));
        }
        return designs;
    }
}

