/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignResourceLoader;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.IPickDesigns;
import com.simibubi.mightyarchitect.control.design.StandardDesignPicker;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum DesignTheme {
    Medieval("medieval", "Medieval", DesignTheme.withLayers(DesignLayer.Foundation, DesignLayer.Regular, DesignLayer.Open, DesignLayer.Independent), DesignTheme.withTypes(DesignType.WALL, DesignType.CORNER, DesignType.ROOF, DesignType.TOWER, DesignType.FACADE, DesignType.FLAT_ROOF, DesignType.TOWER_FLAT_ROOF, DesignType.TOWER_ROOF), new StandardDesignPicker());

    private String filePath;
    private String displayName;
    private IPickDesigns designPicker;
    private List<DesignLayer> layers;
    private List<DesignType> types;
    private Map<DesignLayer, Map<DesignType, Set<Design>>> designs;

    private DesignTheme(String filePath, String displayName, List<DesignLayer> layers, List<DesignType> types, IPickDesigns designPicker) {
        this.filePath = filePath;
        this.displayName = displayName;
        this.designPicker = designPicker;
        this.layers = layers;
        this.types = types;
        this.designPicker.setTheme(this);
    }

    private static List<DesignLayer> withLayers(DesignLayer ... designLayers) {
        return ImmutableList.copyOf((Object[])designLayers);
    }

    private static List<DesignType> withTypes(DesignType ... designtypes) {
        return ImmutableList.copyOf((Object[])designtypes);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IPickDesigns getDesignPicker() {
        return this.designPicker;
    }

    public List<DesignLayer> getLayers() {
        return this.layers;
    }

    public List<DesignType> getTypes() {
        return this.types;
    }

    public Set<Design> getDesigns(DesignLayer designLayer, DesignType designType) {
        Map<DesignType, Set<Design>> typeMap;
        if (this.designs == null) {
            this.designs = DesignResourceLoader.loadDesignsForTheme(this);
        }
        if (!this.getLayers().contains((Object)designLayer)) {
            this.fail(this.getDisplayName() + " theme does not support " + designLayer.getDisplayName() + " layers.");
        }
        if (!this.getTypes().contains((Object)designType)) {
            this.fail(this.getDisplayName() + " theme does not support the type " + designLayer.getDisplayName() + ".");
        }
        if (this.designs.containsKey((Object)designLayer) && (typeMap = this.designs.get((Object)designLayer)).containsKey((Object)designType)) {
            return typeMap.get((Object)designType);
        }
        return new HashSet<Design>();
    }

    private void fail(String message) {
        throw new IllegalArgumentException(message);
    }

    public void clearDesigns() {
        this.designs = null;
    }
}

