/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class Sketch {
    public List<Design.DesignInstance> primary = new LinkedList<Design.DesignInstance>();
    public List<Design.DesignInstance> secondary = new LinkedList<Design.DesignInstance>();
    public List<Room> interior = new LinkedList<Room>();

    public Vector<Map<BlockPos, PaletteBlockInfo>> assemble() {
        Vector<Map<BlockPos, PaletteBlockInfo>> assembled = new Vector<Map<BlockPos, PaletteBlockInfo>>(2);
        HashMap<BlockPos, PaletteBlockInfo> blocksPrimary = new HashMap<BlockPos, PaletteBlockInfo>();
        HashMap<BlockPos, PaletteBlockInfo> blocksSecondary = new HashMap<BlockPos, PaletteBlockInfo>();
        for (Design.DesignInstance design : this.secondary) {
            design.getBlocks(blocksSecondary);
        }
        for (Design.DesignInstance design : this.primary) {
            design.getBlocks(blocksPrimary);
        }
        this.clean(blocksPrimary);
        this.clean(blocksSecondary);
        this.addFloors(blocksPrimary, blocksSecondary);
        assembled.addElement(blocksPrimary);
        assembled.addElement(blocksSecondary);
        return assembled;
    }

    private void clean(Map<BlockPos, PaletteBlockInfo> blocks) {
        LinkedList<BlockPos> toRemove = new LinkedList<BlockPos>();
        for (BlockPos pos : blocks.keySet()) {
            if (blocks.get((Object)pos).palette == Palette.CLEAR) {
                toRemove.add(pos);
                continue;
            }
            for (Room room : this.interior) {
                if (!room.contains(pos)) continue;
                toRemove.add(pos);
            }
        }
        toRemove.forEach(e -> {
            PaletteBlockInfo cfr_ignored_0 = (PaletteBlockInfo)blocks.remove(e);
        });
        toRemove.clear();
    }

    private void addFloors(Map<BlockPos, PaletteBlockInfo> primary, Map<BlockPos, PaletteBlockInfo> secondary) {
        for (Room cuboid : this.interior) {
            LinkedList checked = new LinkedList();
            this.interior.forEach(other -> {
                if (other == cuboid) {
                    return;
                }
                if (!other.intersects(cuboid)) {
                    return;
                }
                if (other.width * other.length > cuboid.width * cuboid.length) {
                    return;
                }
                checked.add(other);
            });
            int y = cuboid.height - 1;
            PaletteBlockInfo paletteBlockInfo = new PaletteBlockInfo(Palette.FLOOR, EnumFacing.UP);
            Map<BlockPos, PaletteBlockInfo> blocks = cuboid.secondaryPalette ? secondary : primary;
            for (int x = 0; x < cuboid.width; ++x) {
                for (int z = 0; z < cuboid.length; ++z) {
                    boolean contained = false;
                    BlockPos pos = cuboid.getOrigin().func_177982_a(x, y, z);
                    for (Room other2 : checked) {
                        if (!other2.contains(pos)) continue;
                        contained = true;
                        break;
                    }
                    if (contained) continue;
                    blocks.put(pos, paletteBlockInfo);
                }
            }
        }
    }
}

