/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.IPickDesigns;
import com.simibubi.mightyarchitect.control.design.Sketch;
import com.simibubi.mightyarchitect.control.design.StyleGroupManager;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.helpful.DesignHelper;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class StandardDesignPicker
implements IPickDesigns {
    private DesignTheme theme;

    @Override
    public Sketch assembleSketch(GroundPlan groundPlan) {
        Sketch sketch = this.pickDesigns(groundPlan);
        return sketch;
    }

    private Sketch pickDesigns(GroundPlan groundPlan) {
        Sketch sketch = new Sketch();
        StyleGroupManager styleGroupManager = new StyleGroupManager();
        groundPlan.forEachStack(stack -> stack.forEach(room -> {
            BlockPos origin = room.getOrigin();
            List<Design.DesignInstance> designList = room.secondaryPalette ? sketch.secondary : sketch.primary;
            StyleGroupManager.StyleGroupDesignProvider styleGroup = styleGroupManager.getStyleGroup(room.styleGroup);
            BlockPos size = room.getSize();
            if (stack instanceof CylinderStack) {
                DesignHelper.addTower(styleGroup, designList, this.theme, room.designLayer, origin, size);
            } else {
                DesignHelper.addCuboid(styleGroup, designList, this.theme, room.designLayer, origin, size);
            }
            if (room != stack.highest()) {
                return;
            }
            DesignLayer roofLayer = DesignLayer.Independent;
            switch (room.roofType) {
                case ROOF: {
                    if (stack instanceof CylinderStack) {
                        DesignHelper.addTowerRoof(styleGroup, designList, this.theme, roofLayer, origin.func_177981_b(room.height), size, false);
                        break;
                    }
                    if (room.width == room.length) {
                        DesignHelper.addNormalCrossRoof(styleGroup, designList, this.theme, roofLayer, origin.func_177981_b(room.height), size);
                        break;
                    }
                    DesignHelper.addNormalRoof(styleGroup, designList, this.theme, roofLayer, origin.func_177981_b(room.height), size);
                    break;
                }
                case FLAT_ROOF: {
                    if (stack instanceof CylinderStack) {
                        DesignHelper.addTowerRoof(styleGroup, designList, this.theme, roofLayer, origin.func_177981_b(room.height), size, true);
                        break;
                    }
                    DesignHelper.addFlatRoof(styleGroup, designList, this.theme, roofLayer, origin.func_177981_b(room.height), size);
                    break;
                }
            }
        }));
        sketch.interior = groundPlan.getInterior();
        return sketch;
    }

    @Override
    public void setTheme(DesignTheme theme) {
        this.theme = theme;
    }
}

