/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.design.DesignQuery;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.helpful.DesignHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class StyleGroupManager {
    private Map<Character, StyleGroupDesignProvider> styleGroups = new HashMap<Character, StyleGroupDesignProvider>();

    public StyleGroupManager() {
        ImmutableList.of((Object)Character.valueOf('A'), (Object)Character.valueOf('B'), (Object)Character.valueOf('C'), (Object)Character.valueOf('D')).forEach(styleGroup -> this.styleGroups.put((Character)styleGroup, new StyleGroupDesignCache()));
        this.styleGroups.put(Character.valueOf('U'), new RandomDesignProvider());
    }

    public StyleGroupDesignProvider getStyleGroup(char group) {
        return this.styleGroups.get(Character.valueOf(group));
    }

    public static class StyleGroupDesignCache
    extends StyleGroupDesignProvider {
        Map<Vector<Integer>, Design> designs = new HashMap<Vector<Integer>, Design>();
        boolean random;

        @Override
        public Design find(DesignQuery query) {
            Vector<Integer> key = query.asCacheKey();
            if (this.designs.containsKey(key)) {
                return this.designs.get(key);
            }
            Design design = DesignHelper.pickRandom(query);
            this.designs.put(key, design);
            return design;
        }
    }

    public static class RandomDesignProvider
    extends StyleGroupDesignProvider {
        @Override
        public Design find(DesignQuery query) {
            return DesignHelper.pickRandom(query);
        }
    }

    public static abstract class StyleGroupDesignProvider {
        public abstract Design find(DesignQuery var1);
    }
}

