/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignQuery;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.helpful.DesignHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ThemeValidator {
    private static final int MIN_RADIUS = 2;
    private static final int MAX_RADIUS = 5;
    private static final int MIN_HEIGHT = 1;
    private static final int MAX_HEIGHT = 10;

    public static void check(DesignTheme theme) {
        ThemeValidator.status("Validating the " + theme.getDisplayName() + " theme...");
        for (DesignLayer layer : theme.getLayers()) {
            block9: for (DesignType type : theme.getTypes()) {
                DesignQuery query = new DesignQuery(theme, layer, type);
                if (!ThemeValidator.exists(query)) continue;
                switch (type) {
                    case CORNER: {
                        for (int height = 1; height <= 10; ++height) {
                            DesignQuery cornerQuery = new DesignQuery(theme, layer, type).withHeight(height);
                            if (ThemeValidator.exists(cornerQuery)) continue;
                            ThemeValidator.alert("No " + layer.getDisplayName() + " " + type.getDisplayName() + " has a height of " + height + "m.");
                        }
                        continue block9;
                    }
                    case NONE: {
                        ThemeValidator.alert("Found design with no type in layer " + layer.getDisplayName() + "!");
                        break;
                    }
                    case ROOF: 
                    case FLAT_ROOF: {
                        for (int span = 5; span <= 15; span += 2) {
                            DesignQuery roofQuery = new DesignQuery(theme, layer, type).withWidth(span);
                            if (ThemeValidator.exists(roofQuery)) continue;
                            ThemeValidator.alert("No " + layer.getDisplayName() + " " + type.getDisplayName() + " has a span of " + span + "m.");
                        }
                        continue block9;
                    }
                    case TOWER: {
                        int radius;
                        for (radius = 2; radius <= 5; ++radius) {
                            for (int height = 1; height <= 10; ++height) {
                                DesignQuery towerQuery = new DesignQuery(theme, layer, type).withWidth(radius * 2 + 1).withHeight(height);
                                if (ThemeValidator.exists(towerQuery)) continue;
                                ThemeValidator.alert("No " + layer.getDisplayName() + " " + type.getDisplayName() + " has radius " + radius + "m and a height of " + height + "m.");
                            }
                        }
                        continue block9;
                    }
                    case TOWER_FLAT_ROOF: 
                    case TOWER_ROOF: {
                        int radius;
                        for (radius = 2; radius <= 5; ++radius) {
                            DesignQuery towerQuery = new DesignQuery(theme, layer, type).withWidth(radius * 2 + 1);
                            if (ThemeValidator.exists(towerQuery)) continue;
                            ThemeValidator.alert("No " + layer.getDisplayName() + " " + type.getDisplayName() + " has a radius of " + radius + "m.");
                        }
                        continue block9;
                    }
                    case WALL: {
                        for (int width = 3; width <= 15; width += 2) {
                            for (int height = 1; height <= 10; ++height) {
                                DesignQuery wallQuery = new DesignQuery(theme, layer, type).withHeight(height).withWidth(width);
                                if (ThemeValidator.exists(wallQuery)) continue;
                                ThemeValidator.alert("No " + layer.getDisplayName() + " " + type.getDisplayName() + " spans " + width + "x" + height + "m.");
                            }
                        }
                        continue block9;
                    }
                }
            }
        }
        ThemeValidator.status("Done checking!");
    }

    private static boolean exists(DesignQuery query) {
        return DesignHelper.pickRandom(query) != null;
    }

    private static void status(String message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("-> " + message));
    }

    private static void alert(String message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u00ef\u00bf\u00bdc!> " + message));
    }
}

