/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design.partials;

import com.google.common.collect.ImmutableSet;
import com.simibubi.mightyarchitect.control.design.DesignSlice;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class Design {
    protected BlockPos size;
    protected DesignSlice[] slices;
    protected Set<Integer> heights;
    protected int defaultHeight;
    protected int defaultWidth;
    protected int yShift;

    public abstract Design fromNBT(NBTTagCompound var1);

    protected void applyNBT(NBTTagCompound compound) {
        this.size = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("Size"));
        this.defaultWidth = this.size.func_177958_n();
        this.slices = new DesignSlice[this.size.func_177956_o()];
        this.defaultHeight = 0;
        this.yShift = 0;
        this.heights = ImmutableSet.of((Object)0);
        NBTTagList sliceTagList = compound.func_150295_c("Layers", 10);
        for (int sliceIndex = 0; sliceIndex < this.slices.length; ++sliceIndex) {
            DesignSlice slice = DesignSlice.fromNBT(sliceTagList.func_150305_b(sliceIndex));
            this.defaultHeight = slice.adjustDefaultHeight(this.defaultHeight);
            this.heights = slice.adjustHeigthsList(this.heights);
            this.slices[sliceIndex] = slice;
            if (slice.getTrait() != DesignSlice.DesignSliceTrait.MaskBelow) continue;
            --this.yShift;
        }
    }

    public void getBlocks(DesignInstance instance, Map<BlockPos, PaletteBlockInfo> blocks) {
        this.getBlocksShifted(instance, blocks, BlockPos.field_177992_a);
    }

    protected void getBlocksShifted(DesignInstance instance, Map<BlockPos, PaletteBlockInfo> blocks, BlockPos localShift) {
        BlockPos position = instance.localAnchor;
        BlockPos totalShift = localShift.func_177982_a(0, this.yShift, 0);
        List<DesignSlice> toPrint = this.selectPrintedLayers(instance.height);
        for (int y = 0; y < toPrint.size(); ++y) {
            DesignSlice layer = toPrint.get(y);
            for (int x = 0; x < this.size.func_177958_n(); ++x) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    Palette key = layer.getBlocks()[z][x];
                    if (key == null) continue;
                    BlockPos pos = this.rotateAroundZero(new BlockPos(x, y, z).func_177971_a((Vec3i)totalShift), instance.rotationY).func_177971_a((Vec3i)position);
                    this.putBlock(blocks, pos, key, EnumFacing.func_176733_a((double)instance.rotationY));
                }
            }
        }
    }

    protected List<DesignSlice> selectPrintedLayers(int targetHeight) {
        LinkedList<DesignSlice> toPrint = new LinkedList<DesignSlice>();
        int currentHeight = this.defaultHeight;
        for (DesignSlice slice : this.slices) {
            currentHeight = slice.addToPrintedLayers(toPrint, currentHeight, targetHeight);
        }
        return toPrint;
    }

    protected void putBlock(Map<BlockPos, PaletteBlockInfo> blocks, BlockPos pos, Palette palette, EnumFacing facing) {
        if (!blocks.containsKey(pos) || !blocks.get((Object)pos).palette.isPrefferedOver(palette)) {
            blocks.put(pos, new PaletteBlockInfo(palette, facing));
        }
    }

    public String toString() {
        String heights = "Heights ";
        for (Integer integer : this.heights) {
            heights = heights + integer + " ";
        }
        return String.format("Design with ", new Object[0]) + heights;
    }

    public boolean fitsHorizontally(int width) {
        return this.defaultWidth == width;
    }

    public boolean fitsVertically(int height) {
        return this.heights.contains(height);
    }

    public BlockPos rotateAroundZero(BlockPos in, int rotation) {
        return this.rotateAround(in, rotation, new BlockPos(0, 0, 0));
    }

    public BlockPos rotateAround(BlockPos in, int rotation, BlockPos origin) {
        int x;
        BlockPos local = in.func_177973_b((Vec3i)origin);
        int n = rotation == 180 ? -local.func_177958_n() : (rotation == 90 ? -local.func_177952_p() : (x = rotation == -90 ? local.func_177952_p() : local.func_177958_n()));
        int z = rotation == 180 ? -local.func_177952_p() : (rotation == 90 ? local.func_177958_n() : (rotation == -90 ? -local.func_177958_n() : local.func_177952_p()));
        BlockPos rotated = new BlockPos(x, local.func_177956_o(), z);
        return rotated.func_177971_a((Vec3i)origin);
    }

    public DesignInstance create(BlockPos anchor, int rotation, int height) {
        return this.create(anchor, rotation, this.size.func_177958_n(), height);
    }

    public DesignInstance create(BlockPos anchor, int rotation, int width, int height) {
        return new DesignInstance(this, anchor, rotation, width, height, 0);
    }

    public class DesignInstance {
        BlockPos localAnchor;
        int rotationY;
        int rotationZ;
        int width;
        int height;
        int depth;
        Design template;

        public DesignInstance(Design template, BlockPos anchor, int rotation, int width, int height, int depth) {
            this.template = template;
            this.localAnchor = anchor;
            this.height = height;
            this.rotationY = rotation;
            this.width = width;
            this.depth = depth;
        }

        public void getBlocks(Map<BlockPos, PaletteBlockInfo> blocks) {
            this.template.getBlocks(this, blocks);
        }

        public Design getTemplate() {
            return this.template;
        }
    }
}

