/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design.partials;

import com.simibubi.mightyarchitect.control.design.DesignSlice;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteBlockInfo;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class Roof
extends Design {
    private static final int CROSS_ROOF_DEPTH = -1;

    @Override
    public Design fromNBT(NBTTagCompound compound) {
        Roof roof = new Roof();
        roof.applyNBT(compound);
        roof.defaultWidth = compound.func_74762_e("Roofspan");
        return roof;
    }

    @Override
    public Design.DesignInstance create(BlockPos anchor, int rotation, int depth) {
        return new Design.DesignInstance(this, anchor, rotation, this.size.func_177958_n(), this.size.func_177956_o(), depth);
    }

    public Design.DesignInstance createAsCross(BlockPos anchor, int rotation, int depth) {
        return new Design.DesignInstance(this, anchor, rotation, this.size.func_177958_n(), this.size.func_177956_o(), -1);
    }

    @Override
    public boolean fitsVertically(int height) {
        return true;
    }

    @Override
    public void getBlocks(Design.DesignInstance instance, Map<BlockPos, PaletteBlockInfo> blocks) {
        int xShift = (this.size.func_177958_n() - this.defaultWidth) / -2;
        int zShift = -2;
        BlockPos position = instance.localAnchor;
        List<DesignSlice> toPrint = this.selectPrintedLayers(instance.height);
        boolean crossRoof = instance.depth == -1;
        int depth = crossRoof ? (this.size.func_177958_n() + (8 - this.defaultWidth)) / 2 : instance.depth;
        BlockPos totalShift = new BlockPos(xShift, this.yShift, zShift);
        for (int y = 0; y < toPrint.size(); ++y) {
            DesignSlice layer = toPrint.get(y);
            for (int x = 0; x < this.size.func_177958_n(); ++x) {
                BlockPos pos;
                Palette key;
                int z;
                int currentDepth = (this.size.func_177958_n() - 1) / 2 - Math.abs((this.size.func_177958_n() - 1) / 2 - x);
                for (z = -(depth + zShift + 1); z < 0; ++z) {
                    key = layer.getBlocks()[0][x];
                    if (key == null || crossRoof && depth - z + zShift > currentDepth) continue;
                    pos = position.func_177971_a((Vec3i)this.rotateAroundZero(new BlockPos(x, y, z).func_177971_a((Vec3i)totalShift), instance.rotationY));
                    this.putBlock(blocks, pos, key, EnumFacing.func_176733_a((double)instance.rotationY));
                }
                for (z = 0; z < this.size.func_177952_p(); ++z) {
                    key = layer.getBlocks()[z][x];
                    if (key == null || crossRoof && depth - z + zShift > currentDepth) continue;
                    pos = this.rotateAroundZero(new BlockPos(x, y, z).func_177971_a((Vec3i)totalShift), instance.rotationY).func_177971_a((Vec3i)position);
                    this.putBlock(blocks, pos, key, EnumFacing.func_176733_a((double)instance.rotationY));
                }
            }
        }
    }
}

