/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.helpful;

import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignQuery;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.StyleGroupManager;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.design.partials.FlatRoof;
import com.simibubi.mightyarchitect.control.design.partials.Roof;
import com.simibubi.mightyarchitect.control.design.partials.Tower;
import com.simibubi.mightyarchitect.control.design.partials.TowerFlatRoof;
import com.simibubi.mightyarchitect.control.design.partials.TowerRoof;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;

public class DesignHelper {
    public static Design pickRandom(DesignQuery query) {
        ArrayList<Design> remainingDesigns = new ArrayList<Design>(query.theme.getDesigns(query.layer, query.type));
        Random dice = new Random();
        while (!remainingDesigns.isEmpty()) {
            int index = dice.nextInt(remainingDesigns.size());
            Design chosen = (Design)remainingDesigns.get(index);
            if ((query.isWidthIgnored() || chosen.fitsHorizontally(query.desiredWidth)) && (query.isHeightIgnored() || chosen.fitsVertically(query.desiredHeight))) {
                return chosen;
            }
            remainingDesigns.remove(index);
        }
        return null;
    }

    public static void addCuboid(StyleGroupManager.StyleGroupDesignProvider designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, BlockPos start, BlockPos size) {
        Design facadeA = null;
        Design facadeB = null;
        int width = size.func_177958_n();
        int height = size.func_177956_o();
        int length = size.func_177952_p();
        DesignQuery facadeQuery = new DesignQuery(theme, layer, DesignType.FACADE).withHeight(height);
        DesignQuery wallQuery = new DesignQuery(theme, layer, DesignType.WALL).withHeight(height);
        DesignLayer cornerLayer = layer != DesignLayer.Open ? layer : DesignLayer.Regular;
        DesignQuery cornerQuery = new DesignQuery(theme, cornerLayer, DesignType.CORNER).withHeight(height);
        if (width <= length) {
            facadeA = designProvider.find(facadeQuery.withWidth(width - 2));
        }
        if (length <= width) {
            facadeB = designProvider.find(facadeQuery.withWidth(length - 2));
        }
        Design wallA = facadeA != null ? facadeA : designProvider.find(wallQuery.withWidth(width - 2));
        Design wallB = facadeB != null ? facadeB : designProvider.find(wallQuery.withWidth(length - 2));
        Design corner = designProvider.find(cornerQuery);
        BlockPos cornerZ = start.func_177982_a(0, 0, length - 1);
        BlockPos cornerXZ = start.func_177982_a(width - 1, 0, length - 1);
        BlockPos cornerX = start.func_177982_a(width - 1, 0, 0);
        if (wallA != null && wallB != null && corner != null) {
            designList.add(DesignHelper.wall(wallA, cornerZ, cornerXZ, height));
            designList.add(DesignHelper.wall(wallB, cornerXZ, cornerX, height));
            designList.add(DesignHelper.wall(wallA, cornerX, start, height));
            designList.add(DesignHelper.wall(wallB, start, cornerZ, height));
            designList.add(DesignHelper.corner(corner, start, 135, height));
            designList.add(DesignHelper.corner(corner, cornerZ, 45, height));
            designList.add(DesignHelper.corner(corner, cornerXZ, -45, height));
            designList.add(DesignHelper.corner(corner, cornerX, -135, height));
        }
    }

    public static void addTower(StyleGroupManager.StyleGroupDesignProvider designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, BlockPos start, BlockPos size) {
        int diameter = size.func_177958_n();
        int height = size.func_177956_o();
        DesignQuery towerQuery = new DesignQuery(theme, layer, DesignType.TOWER).withWidth(diameter).withHeight(height);
        Design tower = designProvider.find(towerQuery);
        if (tower == null) {
            return;
        }
        designList.add(DesignHelper.tower(tower, start, height));
    }

    public static void addTowerRoof(StyleGroupManager.StyleGroupDesignProvider designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, BlockPos start, BlockPos size, boolean flat) {
        int diameter;
        DesignType type = flat ? DesignType.TOWER_FLAT_ROOF : DesignType.TOWER_ROOF;
        DesignQuery roofQuery = new DesignQuery(theme, layer, type).withWidth(diameter = size.func_177958_n());
        Design roof = designProvider.find(roofQuery);
        if (roof == null) {
            return;
        }
        designList.add(flat ? DesignHelper.towerFlatRoof(roof, start) : DesignHelper.towerRoof(roof, start));
    }

    public static void addNormalRoof(StyleGroupManager.StyleGroupDesignProvider designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, BlockPos start, BlockPos size) {
        boolean south = size.func_177952_p() < size.func_177958_n();
        int depth = south ? size.func_177958_n() : size.func_177952_p();
        int width = south ? size.func_177952_p() : size.func_177958_n();
        BlockPos cornerZ = start.func_177982_a(0, 0, size.func_177952_p() - 1);
        BlockPos cornerXZ = start.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
        BlockPos cornerX = start.func_177982_a(size.func_177958_n() - 1, 0, 0);
        Design roof = designProvider.find(new DesignQuery(theme, layer, DesignType.ROOF).withWidth(width));
        if (roof == null) {
            return;
        }
        designList.add(DesignHelper.roof(roof, south ? start : cornerX, south ? 90 : 180, depth - 4));
        designList.add(DesignHelper.roof(roof, south ? cornerXZ : cornerZ, south ? -90 : 0, depth - 4));
    }

    public static void addNormalCrossRoof(StyleGroupManager.StyleGroupDesignProvider designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, BlockPos start, BlockPos size) {
        boolean south = size.func_177952_p() < size.func_177958_n();
        int depth = south ? size.func_177958_n() : size.func_177952_p();
        int width = south ? size.func_177952_p() : size.func_177958_n();
        BlockPos cornerZ = start.func_177982_a(0, 0, size.func_177952_p() - 1);
        BlockPos cornerXZ = start.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
        BlockPos cornerX = start.func_177982_a(size.func_177958_n() - 1, 0, 0);
        Design roof = designProvider.find(new DesignQuery(theme, layer, DesignType.ROOF).withWidth(width));
        if (roof == null) {
            return;
        }
        designList.add(DesignHelper.quadRoof(roof, start, 90, depth - 4));
        designList.add(DesignHelper.quadRoof(roof, cornerXZ, -90, depth - 4));
        designList.add(DesignHelper.quadRoof(roof, cornerX, 180, depth - 4));
        designList.add(DesignHelper.quadRoof(roof, cornerZ, 0, depth - 4));
    }

    public static void addFlatRoof(StyleGroupManager.StyleGroupDesignProvider designProvider, List<Design.DesignInstance> designList, DesignTheme theme, DesignLayer layer, BlockPos start, BlockPos size) {
        boolean south = size.func_177952_p() < size.func_177958_n();
        int depth = south ? size.func_177958_n() : size.func_177952_p();
        int width = south ? size.func_177952_p() : size.func_177958_n();
        BlockPos cornerZ = start.func_177982_a(0, 0, size.func_177952_p() - 1);
        BlockPos cornerXZ = start.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
        BlockPos cornerX = start.func_177982_a(size.func_177958_n() - 1, 0, 0);
        Design flatroof = designProvider.find(new DesignQuery(theme, layer, DesignType.FLAT_ROOF).withWidth(width));
        if (flatroof == null) {
            return;
        }
        designList.add(DesignHelper.flatroof(flatroof, south ? start : cornerX, south ? 90 : 180, width, depth));
        designList.add(DesignHelper.flatroof(flatroof, south ? cornerXZ : cornerZ, south ? -90 : 0, width, depth));
    }

    public static Design.DesignInstance wall(Design design, BlockPos corner1, BlockPos corner2, int height) {
        int xDiff = corner2.func_177958_n() - corner1.func_177958_n();
        int zDiff = corner2.func_177952_p() - corner1.func_177952_p();
        int xStep = (int)Math.signum(xDiff);
        int zStep = (int)Math.signum(zDiff);
        corner1 = corner1.func_177982_a(xStep, 0, zStep);
        int width = Math.abs(xDiff == 0 ? zDiff : xDiff) - 1;
        int rotation = xDiff == 0 ? (zDiff > 0 ? 90 : -90) : (xDiff > 0 ? 0 : 180);
        return design.create(corner1, rotation, width, height);
    }

    public static Design.DesignInstance corner(Design design, BlockPos pos, int angle, int height) {
        return design.create(pos, angle + 45, height);
    }

    public static Design.DesignInstance trim(Design design, BlockPos pos, int angle, int height) {
        return design.create(pos, angle, height);
    }

    public static Design.DesignInstance roof(Design design, BlockPos pos, int angle, int depth) {
        return ((Roof)design).create(pos, angle, depth);
    }

    public static Design.DesignInstance quadRoof(Design design, BlockPos pos, int angle, int depth) {
        return ((Roof)design).createAsCross(pos, angle, depth);
    }

    public static Design.DesignInstance flatroof(Design design, BlockPos pos, int angle, int width, int depth) {
        return ((FlatRoof)design).create(pos, angle, width, depth);
    }

    public static Design.DesignInstance tower(Design design, BlockPos pos, int height) {
        return ((Tower)design).create(pos, height);
    }

    public static Design.DesignInstance towerRoof(Design design, BlockPos pos) {
        return ((TowerRoof)design).create(pos);
    }

    public static Design.DesignInstance towerFlatRoof(Design design, BlockPos pos) {
        return ((TowerFlatRoof)design).create(pos);
    }
}

