/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.helpful;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class FilesHelper {
    public static void createFolderIfMissing(String name) {
        if (!Files.isDirectory(Paths.get(name, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get(name, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                TheMightyArchitect.logger.warn("Could not create Folder: " + name);
            }
        }
    }

    public static String findFirstValidFilename(String name, String folderPath, String extension) {
        String filename;
        String filepath;
        int index = 0;
        do {
            filename = name.toLowerCase().replace(' ', '_') + (index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(Paths.get(filepath = folderPath + "/" + filename, new String[0]), new LinkOption[0]));
        return filename;
    }

    public static boolean saveTagCompoundAsJson(NBTTagCompound compound, String path) {
        try {
            Files.deleteIfExists(Paths.get(path, new String[0]));
            JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(Paths.get(path, new String[0]), StandardOpenOption.CREATE));
            writer.setIndent("  ");
            Streams.write((JsonElement)new JsonParser().parse(compound.toString()), (JsonWriter)writer);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static NBTTagCompound loadJsonResourceAsNBT(String filepath) {
        try {
            JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(TheMightyArchitect.class.getClassLoader().getResourceAsStream(filepath))));
            reader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)reader);
            return JsonToNBT.func_180713_a((String)element.toString());
        }
        catch (NBTException e) {
            e.printStackTrace();
            return null;
        }
    }
}

