/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.helpful;

import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RaycastHelper {
    public static RayTraceResult rayTraceRange(World worldIn, EntityPlayer playerIn, double range) {
        Vec3d origin = RaycastHelper.getTraceOrigin(playerIn);
        Vec3d target = RaycastHelper.getTraceTarget(playerIn, range, origin);
        return worldIn.func_147447_a(origin, target, false, true, false);
    }

    public static PredicateTraceResult rayTraceUntil(EntityPlayer playerIn, double range, Predicate<BlockPos> predicate) {
        Vec3d origin = RaycastHelper.getTraceOrigin(playerIn);
        Vec3d target = RaycastHelper.getTraceTarget(playerIn, range, origin);
        return RaycastHelper.rayTraceUntil(origin, target, predicate);
    }

    private static Vec3d getTraceTarget(EntityPlayer playerIn, double range, Vec3d origin) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = range;
        Vec3d vec3d1 = origin.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return vec3d1;
    }

    private static Vec3d getTraceOrigin(EntityPlayer playerIn) {
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        return vec3d;
    }

    private static PredicateTraceResult rayTraceUntil(Vec3d start, Vec3d end, Predicate<BlockPos> predicate) {
        int z;
        int y;
        if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
            return null;
        }
        int dx = MathHelper.func_76128_c((double)end.field_72450_a);
        int dy = MathHelper.func_76128_c((double)end.field_72448_b);
        int dz = MathHelper.func_76128_c((double)end.field_72449_c);
        int x = MathHelper.func_76128_c((double)start.field_72450_a);
        BlockPos currentPos = new BlockPos(x, y = MathHelper.func_76128_c((double)start.field_72448_b), z = MathHelper.func_76128_c((double)start.field_72449_c));
        if (predicate.test(currentPos)) {
            return new PredicateTraceResult(currentPos, EnumFacing.func_176737_a((float)(dx - x), (float)(dy - y), (float)(dz - z)));
        }
        int remainingDistance = 200;
        while (remainingDistance-- >= 0) {
            EnumFacing enumfacing;
            if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                return null;
            }
            if (x == dx && y == dy && z == dz) {
                return new PredicateTraceResult();
            }
            boolean flag2 = true;
            boolean flag = true;
            boolean flag1 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (dx > x) {
                d0 = (double)x + 1.0;
            } else if (dx < x) {
                d0 = (double)x + 0.0;
            } else {
                flag2 = false;
            }
            if (dy > y) {
                d1 = (double)y + 1.0;
            } else if (dy < y) {
                d1 = (double)y + 0.0;
            } else {
                flag = false;
            }
            if (dz > z) {
                d2 = (double)z + 1.0;
            } else if (dz < z) {
                d2 = (double)z + 0.0;
            } else {
                flag1 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end.field_72450_a - start.field_72450_a;
            double d7 = end.field_72448_b - start.field_72448_b;
            double d8 = end.field_72449_c - start.field_72449_c;
            if (flag2) {
                d3 = (d0 - start.field_72450_a) / d6;
            }
            if (flag) {
                d4 = (d1 - start.field_72448_b) / d7;
            }
            if (flag1) {
                d5 = (d2 - start.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = dx > x ? EnumFacing.WEST : EnumFacing.EAST;
                start = new Vec3d(d0, start.field_72448_b + d7 * d3, start.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = dy > y ? EnumFacing.DOWN : EnumFacing.UP;
                start = new Vec3d(start.field_72450_a + d6 * d4, d1, start.field_72449_c + d8 * d4);
            } else {
                enumfacing = dz > z ? EnumFacing.NORTH : EnumFacing.SOUTH;
                start = new Vec3d(start.field_72450_a + d6 * d5, start.field_72448_b + d7 * d5, d2);
            }
            if (!predicate.test(currentPos = new BlockPos(x = MathHelper.func_76128_c((double)start.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0), y = MathHelper.func_76128_c((double)start.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0), z = MathHelper.func_76128_c((double)start.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0)))) continue;
            return new PredicateTraceResult(currentPos, enumfacing);
        }
        return new PredicateTraceResult();
    }

    public static class PredicateTraceResult {
        private BlockPos pos;
        private EnumFacing facing;

        public PredicateTraceResult(BlockPos pos, EnumFacing facing) {
            this.pos = pos;
            this.facing = facing;
        }

        public PredicateTraceResult() {
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public boolean missed() {
            return this.pos == null;
        }
    }
}

