/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.palette;

import com.simibubi.mightyarchitect.control.palette.Palette;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;

public class PaletteDefinition {
    private Map<Palette, IBlockState> definition = new HashMap<Palette, IBlockState>();
    private String name;
    private IBlockState clear;
    private static PaletteDefinition defaultPalette;

    public static PaletteDefinition defaultPalette() {
        if (defaultPalette == null) {
            defaultPalette = new PaletteDefinition("Standard Palette");
            defaultPalette.put(Palette.HEAVY_PRIMARY, Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH)).put(Palette.HEAVY_SECONDARY, Blocks.field_150347_e.func_176223_P()).put(Palette.HEAVY_WINDOW, Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)EnumDyeColor.BLACK)).put(Palette.HEAVY_POST, Blocks.field_150463_bK.func_176223_P().func_177226_a((IProperty)BlockWall.field_176255_P, (Comparable)BlockWall.EnumType.MOSSY)).put(Palette.INNER_DETAIL, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE)).put(Palette.INNER_PRIMARY, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE)).put(Palette.INNER_SECONDARY, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.DARK_OAK)).put(Palette.OUTER_FLAT, Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true))).put(Palette.OUTER_SLAB, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE)).put(Palette.OUTER_THICK, Blocks.field_150463_bK.func_176223_P()).put(Palette.OUTER_THIN, Blocks.field_180408_aP.func_176223_P()).put(Palette.ROOF_PRIMARY, Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE)).put(Palette.FLOOR, Blocks.field_150344_f.func_176223_P()).put(Palette.ROOF_DETAIL, Blocks.field_150336_V.func_176223_P()).put(Palette.CLEAR, Blocks.field_150359_w.func_176223_P()).put(Palette.ROOF_SLAB, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.BRICK)).put(Palette.ROOF_SLAB_TOP, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.BRICK).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP)).put(Palette.WINDOW, Blocks.field_150410_aZ.func_176223_P());
        }
        return defaultPalette;
    }

    public PaletteDefinition clone() {
        PaletteDefinition clone = new PaletteDefinition(this.name);
        clone.clear = PaletteDefinition.defaultPalette().clear();
        clone.definition = new HashMap<Palette, IBlockState>(PaletteDefinition.defaultPalette().getDefinition());
        this.definition.forEach((key, value) -> clone.definition.put((Palette)((Object)key), (IBlockState)value));
        return clone;
    }

    public PaletteDefinition(String name) {
        this.definition.put(Palette.CLEAR, Blocks.field_150359_w.func_176223_P());
        this.name = name;
    }

    public PaletteDefinition put(Palette key, IBlockState block) {
        if (block.func_177230_c() instanceof BlockTrapDoor) {
            block = block.func_177226_a((IProperty)BlockTrapDoor.field_176283_b, (Comparable)Boolean.valueOf(true));
        }
        this.definition.put(key, block);
        return this;
    }

    public Map<Palette, IBlockState> getDefinition() {
        return this.definition;
    }

    public IBlockState clear() {
        if (this.clear == null) {
            this.clear = this.get(Palette.CLEAR, EnumFacing.UP);
        }
        return this.clear;
    }

    public IBlockState get(Palette key, EnumFacing facing) {
        IBlockState iBlockState = this.definition.get((Object)key);
        if (key == Palette.ROOF_SLAB_TOP) {
            IBlockState roofSlab = this.get(Palette.ROOF_SLAB, facing);
            if (roofSlab.func_177227_a().contains(BlockSlab.field_176554_a)) {
                return roofSlab.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
            }
            return roofSlab;
        }
        return iBlockState == null ? Blocks.field_150350_a.func_176223_P() : iBlockState.func_185907_a(this.rotationFromFacing(facing));
    }

    private Rotation rotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case WEST: {
                return Rotation.CLOCKWISE_90;
            }
            case NORTH: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return Rotation.NONE;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = compound == null ? new NBTTagCompound() : compound;
        NBTTagCompound palette = new NBTTagCompound();
        palette.func_74778_a("Name", this.getName());
        Palette[] values = Palette.values();
        for (int i = 0; i < values.length; ++i) {
            NBTTagCompound state = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)this.get(values[i], EnumFacing.UP));
            palette.func_74782_a(values[i].name(), (NBTBase)state);
        }
        compound.func_74782_a("Palette", (NBTBase)palette);
        return compound;
    }

    public static PaletteDefinition fromNBT(NBTTagCompound compound) {
        PaletteDefinition palette = PaletteDefinition.defaultPalette().clone();
        if (compound != null && compound.func_74764_b("Palette")) {
            NBTTagCompound paletteTag = compound.func_74775_l("Palette");
            palette.name = paletteTag.func_74779_i("Name");
            for (Palette key : Palette.values()) {
                if (!paletteTag.func_74764_b(key.name())) continue;
                palette.put(key, NBTUtil.func_190008_d((NBTTagCompound)paletteTag.func_74775_l(key.name())));
            }
        }
        return palette;
    }
}

