/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.compose.planner.Tools;
import com.simibubi.mightyarchitect.control.helpful.ShaderManager;
import com.simibubi.mightyarchitect.control.helpful.Shaders;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.phase.IRenderGameOverlay;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class PhaseComposing
extends PhaseBase
implements IRenderGameOverlay {
    private Tools activeTool;

    @Override
    public void whenEntered() {
        this.activeTool = Tools.Room;
        this.activeTool.getTool().init();
        ShaderManager.setActiveShader(Shaders.Blueprint);
    }

    @Override
    public void update() {
        this.activeTool.getTool().updateSelection();
    }

    @Override
    public void onClick(int button) {
        if (button == 1) {
            String message = this.activeTool.getTool().handleRightClick();
            this.sendStatusMessage(message);
        }
    }

    @Override
    public void onKey(int key) {
        if (key == 205) {
            this.activeTool = this.activeTool.next();
            this.activeTool.getTool().init();
            return;
        }
        if (key == 203) {
            this.activeTool = this.activeTool.previous();
            this.activeTool.getTool().init();
            return;
        }
        this.activeTool.getTool().handleKey(key);
    }

    @Override
    public void render() {
        TessellatorHelper.prepareForDrawing();
        this.activeTool.getTool().renderGroundPlan();
        this.activeTool.getTool().renderTool();
        TessellatorHelper.cleanUpAfterDrawing();
    }

    @Override
    public void whenExited() {
        ShaderManager.stopUsingShaders();
    }

    @Override
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        ScaledResolution scaledresolution = new ScaledResolution(this.minecraft);
        this.minecraft.field_71466_p.func_175065_a(this.activeTool.getDisplayName(), (float)(scaledresolution.func_78326_a() / 2 + 15), (float)(scaledresolution.func_78328_b() / 2 + 5), 0xDDDDDD, true);
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"Draw the layout of your build, adding rooms, towers and other. Modify their size, style and palette using the Selection Tool.", (Object)"Use your < > Arrow Keys to switch tools.");
    }
}

