/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.phase;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.SchematicHologram;
import com.simibubi.mightyarchitect.control.helpful.TesselatorTextures;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.phase.IDrawBlockHighlights;
import com.simibubi.mightyarchitect.control.phase.IListenForBlockEvents;
import com.simibubi.mightyarchitect.control.phase.PhaseBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;

public class PhaseCreatingPalette
extends PhaseBase
implements IListenForBlockEvents,
IDrawBlockHighlights {
    private PaletteDefinition palette;
    private BlockPos center;
    private Map<BlockPos, Palette> grid;

    @Override
    public void whenEntered() {
        Schematic model = this.getModel();
        WorldClient world = this.minecraft.field_71441_e;
        this.palette = model.getCreatedPalette();
        this.center = world.func_175645_m(this.minecraft.field_71439_g.func_180425_c());
        this.grid = new HashMap<BlockPos, Palette>();
        for (int i = 0; i < 16; ++i) {
            BlockPos pos = this.positionFromIndex(i);
            this.grid.put(pos, Palette.values()[i]);
            if (world.func_175623_d(pos)) continue;
            this.palette.put(Palette.values()[i], world.func_180495_p(pos));
        }
        model.updatePalettePreview();
        SchematicHologram.display(this.getModel());
    }

    @Override
    public void update() {
    }

    @Override
    public void render() {
        int i;
        TessellatorHelper.prepareForDrawing();
        TesselatorTextures.RoomTransparent.bind();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < 16; ++i) {
            TessellatorHelper.cube(bufferBuilder, this.positionFromIndex(i), new BlockPos(1, 1, 1), 0.125, true, true);
        }
        Tessellator.func_178181_a().func_78381_a();
        this.minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (i = 0; i < 16; ++i) {
            PaletteDefinition paletteDef;
            IBlockState state = this.palette.get(Palette.values()[i], EnumFacing.UP);
            PaletteDefinition paletteDefinition = paletteDef = this.getModel().isEditingPrimary() ? this.getModel().getPrimary() : this.getModel().getSecondary();
            if (state == null || !state.equals(paletteDef.get(Palette.values()[i], EnumFacing.UP))) continue;
            GlStateManager.func_179094_E();
            BlockPos translate = this.positionFromIndex(i);
            this.minecraft.func_175602_ab().func_175018_a(state, translate, (IBlockAccess)this.minecraft.field_71441_e, bufferBuilder);
            GlStateManager.func_179121_F();
        }
        Tessellator.func_178181_a().func_78381_a();
        TessellatorHelper.cleanUpAfterDrawing();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    @Override
    public void whenExited() {
        this.getModel().stopPalettePreview();
        SchematicHologram.reset();
    }

    @Override
    public void onBlockPlaced(BlockPos pos, IBlockState state) {
        if (this.grid.containsKey(pos)) {
            this.palette.put(this.grid.get(pos), state);
            this.notifyChange();
        }
    }

    protected void notifyChange() {
        this.getModel().updatePalettePreview();
        SchematicHologram.getInstance().schematicChanged();
    }

    @Override
    public void onBlockBroken(BlockPos pos) {
        if (this.grid.containsKey(pos)) {
            PaletteDefinition paletteDef = this.getModel().isEditingPrimary() ? this.getModel().getPrimary() : this.getModel().getSecondary();
            Palette key = this.grid.get(pos);
            this.palette.put(key, paletteDef.get(key, EnumFacing.UP));
            this.notifyChange();
        }
    }

    @Override
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        BlockPos targetBlock;
        RayTraceResult raytrace = event.getTarget();
        if (raytrace != null && raytrace.field_72313_a == RayTraceResult.Type.BLOCK && this.grid.containsKey(targetBlock = raytrace.func_178782_a().func_177972_a(raytrace.field_178784_b))) {
            TessellatorHelper.prepareForDrawing();
            TessellatorHelper.drawString(this.grid.get(targetBlock).getDisplayName(), (float)targetBlock.func_177958_n() + 0.5f, (float)targetBlock.func_177984_a().func_177956_o() + 0.3f, (float)targetBlock.func_177952_p() + 0.5f, false, true);
            TessellatorHelper.cleanUpAfterDrawing();
        }
    }

    private BlockPos positionFromIndex(int index) {
        return this.center.func_177965_g(-3 + index % 4 * 2).func_177970_e(-3 + index / 4 * 2);
    }

    @Override
    public List<String> getToolTip() {
        return ImmutableList.of((Object)"The Ghost blocks show the individual materials used in this build.", (Object)"Modify the palette by placing blocks into the marked areas. You do not have to fill all the gaps.", (Object)"Once finished, make sure to save it. [F]");
    }
}

