/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.gui.GuiResources;
import com.simibubi.mightyarchitect.proxy.CombinedClientProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Keyboard;

public class GuiArchitectMenu
extends GuiScreen {
    private Map<String, String> keybinds = new HashMap<String, String>();
    private String title = "";
    private List<String> tooltip = new ArrayList<String>();
    private boolean focused = false;
    private boolean visible = false;
    private int menuWidth;
    private int menuHeight;
    private int targetY = 0;
    private float movingY = 0.0f;

    public GuiArchitectMenu() {
        this.adjustTarget();
    }

    public void updateContents() {
        int fontheight = Minecraft.func_71410_x().field_71466_p.field_78288_b;
        this.tooltip = ArchitectManager.getPhase().getPhaseHandler().getToolTip();
        this.keybinds = ArchitectManager.getKeybinds();
        this.title = ArchitectManager.getPhase().getDisplayTitle();
        this.menuWidth = 158;
        this.menuHeight = 4;
        this.menuHeight += 12;
        this.menuHeight += 4 + this.keybinds.size() * fontheight;
        this.menuHeight += 4;
        for (String s : this.tooltip) {
            int lines = Minecraft.func_71410_x().field_71466_p.func_78271_c(s, this.menuWidth - 8).size();
            this.menuHeight += lines * fontheight + 2;
        }
        this.adjustTarget();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.draw(partialTicks);
    }

    public void drawPassive() {
        if (this.func_193976_p()) {
            return;
        }
        this.draw(Minecraft.func_71410_x().func_184121_ak());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == CombinedClientProxy.COMPOSE.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        if (ArchitectManager.handleMenuInput(keyCode, typedChar)) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    private void draw(float partialTicks) {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int x = res.func_78326_a() - this.menuWidth - 10;
        int y = res.func_78328_b() - this.menuHeight;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)this.yShift(partialTicks), (float)0.0f);
        GuiResources gray = GuiResources.GRAY;
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
        GuiArchitectMenu.func_146110_a((int)x, (int)y, (float)gray.startX, (float)gray.startY, (int)this.menuWidth, (int)this.menuHeight, (float)gray.width, (float)gray.height);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int yPos = y + 4;
        int xPos = x + 4;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (!this.focused) {
            font.func_175065_a("Press " + Keyboard.getKeyName((int)CombinedClientProxy.COMPOSE.func_151463_i()) + " to focus", (float)xPos, (float)(yPos - 14), 0xEEEEEE, true);
        }
        font.func_175065_a(this.title, (float)xPos, (float)yPos, 0xEEEEEE, false);
        yPos += 4;
        for (String key : this.keybinds.keySet()) {
            font.func_175065_a("[" + key + "] " + this.keybinds.get(key), (float)xPos, (float)(yPos += font.field_78288_b), 0xEEEEEE, false);
            font.func_175065_a(">", (float)(xPos - 12), (float)yPos, 0xCCDDFF, true);
        }
        yPos += 4;
        yPos += font.field_78288_b;
        for (String text : this.tooltip) {
            int lines = Minecraft.func_71410_x().field_71466_p.func_78271_c(text, this.menuWidth - 8).size();
            font.func_78279_b(text, xPos, yPos, this.menuWidth - 8, 0xEEEEEE);
            yPos += font.field_78288_b * lines + 2;
        }
        GlStateManager.func_179121_F();
    }

    public boolean func_73868_f() {
        return false;
    }

    public boolean func_193976_p() {
        return this.focused;
    }

    public void func_193975_a(boolean focused) {
        this.focused = focused;
        this.adjustTarget();
    }

    protected void adjustTarget() {
        this.targetY = this.visible ? (this.focused ? 0 : this.menuHeight - 14) : this.menuHeight + 20;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.adjustTarget();
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.func_193975_a(false);
    }

    private float yShift(float partialTicks) {
        return this.movingY + ((float)this.targetY - this.movingY) * 0.2f * partialTicks;
    }

    public void onClientTick() {
        if (this.movingY != (float)this.targetY) {
            this.movingY = (float)((double)this.movingY + (double)((float)this.targetY - this.movingY) * 0.2);
        }
    }
}

