/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.google.common.collect.Lists;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.gui.GuiResources;
import com.simibubi.mightyarchitect.gui.widgets.DynamicLabel;
import com.simibubi.mightyarchitect.gui.widgets.GuiIndicator;
import com.simibubi.mightyarchitect.gui.widgets.ScrollArea;
import com.simibubi.mightyarchitect.gui.widgets.SimiButton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiComposer
extends GuiScreen {
    private static final int BUTTON_ADD_LAYER = 0;
    private static final int BUTTON_NORMAL_ROOF = 1;
    private static final int BUTTON_FLAT_ROOF = 2;
    private static final int BUTTON_NO_ROOF = 3;
    private static final int BUTTON_REMOVE_LAYER = 4;
    private List<GuiComposerPartial> partials;
    private int xSize;
    private int ySize;
    private int xTopLeft;
    private int yTopLeft;
    private Stack stack;
    private SimiButton buttonNormalRoof;
    private SimiButton buttonFlatRoof;
    private SimiButton buttonNoRoof;
    private GuiIndicator indicatorNormalRoof;
    private GuiIndicator indicatorFlatRoof;
    private GuiIndicator indicatorNoRoof;

    public GuiComposer(Stack stack) {
        this.stack = stack;
    }

    private void init(Stack stack) {
        this.partials = new ArrayList<GuiComposerPartial>();
        this.field_146292_n.clear();
        List<Room> rooms = stack.getRooms();
        stack.forEach(room -> this.partials.add(new GuiComposerPartial(this, (Room)room, rooms.indexOf(room))));
        this.xSize = 256;
        this.ySize = 58 + (stack.floors() - 1) * 52 + 20;
        this.xTopLeft = (this.field_146294_l - this.xSize) / 2;
        this.yTopLeft = (this.field_146295_m - this.ySize) / 2;
        this.buttonNormalRoof = new SimiButton(1, this.xTopLeft + 60, this.yTopLeft, GuiResources.ICON_NORMAL_ROOF);
        this.indicatorNormalRoof = new GuiIndicator(this.xTopLeft + 60, this.yTopLeft - 5, "");
        this.buttonFlatRoof = new SimiButton(2, this.xTopLeft + 80, this.yTopLeft, GuiResources.ICON_FLAT_ROOF);
        this.indicatorFlatRoof = new GuiIndicator(this.xTopLeft + 80, this.yTopLeft - 5, "");
        this.buttonNoRoof = new SimiButton(3, this.xTopLeft + 100, this.yTopLeft, GuiResources.ICON_NO_ROOF);
        this.indicatorNoRoof = new GuiIndicator(this.xTopLeft + 100, this.yTopLeft - 5, "");
        this.field_146292_n.add(this.buttonNormalRoof);
        this.field_146292_n.add(this.buttonFlatRoof);
        this.field_146292_n.add(this.buttonNoRoof);
        this.swapRoofTypeIfNecessary();
        this.indicate(stack.highest().roofType == DesignType.ROOF ? this.indicatorNormalRoof : (stack.highest().roofType == DesignType.FLAT_ROOF ? this.indicatorFlatRoof : this.indicatorNoRoof));
    }

    private boolean normalRoofPossible() {
        return Math.min(this.stack.highest().width, this.stack.highest().length) <= 15;
    }

    private void swapRoofTypeIfNecessary() {
        this.buttonNormalRoof.field_146124_l = this.normalRoofPossible();
        if (this.normalRoofPossible()) {
            return;
        }
        if (this.stack.highest().roofType != DesignType.ROOF) {
            return;
        }
        this.stack.highest().roofType = DesignType.FLAT_ROOF;
        this.indicate(this.indicatorFlatRoof);
    }

    public void func_73866_w_() {
        this.init(this.stack);
        if (this.stack.floors() <= 4) {
            this.func_189646_b(new SimiButton(0, this.xTopLeft + 2, this.yTopLeft, GuiResources.ICON_ADD));
        }
        this.func_189646_b(new SimiButton(4, this.xTopLeft + 22, this.yTopLeft, GuiResources.ICON_TRASH));
        for (int layer = 0; layer < this.partials.size(); ++layer) {
            GuiComposerPartial partial = this.partials.get(layer);
            int offset = (this.partials.size() - layer - 1) * 52 + 20;
            partial.initGui(offset);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        for (int layer = 0; layer < this.partials.size(); ++layer) {
            GuiComposerPartial partial = this.partials.get(layer);
            int offset = (this.partials.size() - layer - 1) * 52 + 20;
            partial.drawScreen(offset, mouseX, mouseY, partialTicks);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.indicatorNormalRoof.render(this.field_146297_k, mouseX, mouseY);
        this.indicatorFlatRoof.render(this.field_146297_k, mouseX, mouseY);
        this.indicatorNoRoof.render(this.field_146297_k, mouseX, mouseY);
        for (GuiComposerPartial partial : this.partials) {
            for (ScrollArea area : partial.scrollAreas) {
                area.draw(this, mouseX, mouseY);
            }
        }
    }

    public void updateAllPositioningLabels() {
        for (GuiComposerPartial partial : this.partials) {
            partial.updatePositioningLabels();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                this.stack.increase();
                this.func_73866_w_();
                return;
            }
            case 4: {
                if (Keyboard.isKeyDown((int)42) || this.stack.floors() == 1) {
                    ArchitectManager.getModel().getGroundPlan().remove(this.stack);
                    this.field_146297_k.func_147108_a(null);
                    return;
                }
                this.stack.decrease();
                this.func_73866_w_();
                return;
            }
            case 1: {
                this.stack.highest().roofType = DesignType.ROOF;
                this.indicate(this.indicatorNormalRoof);
                return;
            }
            case 2: {
                this.stack.highest().roofType = DesignType.FLAT_ROOF;
                this.indicate(this.indicatorFlatRoof);
                return;
            }
            case 3: {
                this.stack.highest().roofType = DesignType.NONE;
                this.indicate(this.indicatorNoRoof);
                return;
            }
        }
    }

    private void indicate(GuiIndicator indicator) {
        this.indicatorNormalRoof.state = indicator == this.indicatorNormalRoof ? GuiIndicator.State.ON : GuiIndicator.State.OFF;
        this.indicatorFlatRoof.state = indicator == this.indicatorFlatRoof ? GuiIndicator.State.ON : GuiIndicator.State.OFF;
        this.indicatorNoRoof.state = indicator == this.indicatorNoRoof ? GuiIndicator.State.ON : GuiIndicator.State.OFF;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int scrollAmount = (mouseButton == 0 ? -1 : 1) * (Keyboard.isKeyDown((int)42) ? 5 : 1);
        for (GuiComposerPartial partial : this.partials) {
            for (ScrollArea area : partial.scrollAreas) {
                area.tryScroll(mouseX, mouseY, scrollAmount);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            for (GuiComposerPartial partial : this.partials) {
                for (ScrollArea area : partial.scrollAreas) {
                    area.tryScroll(i, j, (int)((float)scroll / -120.0f));
                }
            }
        }
    }

    class GuiComposerPartial {
        private List<ScrollArea> scrollAreas = new ArrayList<ScrollArea>();
        private Room cuboid;
        private GuiComposer parent;
        private int layer;
        private Vector<ScrollArea> scrollAreaPosition;
        private Vector<ScrollArea> scrollAreaSize;
        private Vector<DynamicLabel> labelPosition;
        private Vector<DynamicLabel> labelSize;
        private DynamicLabel style;
        private DynamicLabel styleGroup;
        private DynamicLabel paletteGroup;

        public GuiComposerPartial(GuiComposer parent, Room cuboid, int layer) {
            this.cuboid = cuboid;
            this.layer = layer;
            this.parent = parent;
            this.labelPosition = new Vector(3);
            this.labelSize = new Vector(3);
            this.scrollAreaPosition = new Vector(3);
            this.scrollAreaSize = new Vector(3);
        }

        public void initGui(int yOffset) {
            this.scrollAreas.clear();
            int x = this.parent.xTopLeft;
            int y = this.parent.yTopLeft + yOffset;
            this.style = new DynamicLabel(x + 78, y + 15);
            this.styleGroup = new DynamicLabel(x + 131, y + 35);
            this.paletteGroup = new DynamicLabel(x + 92, y + 35);
            this.initPosAndSizeFields(x, y);
            this.initStyleAndStyleGroupFields(x, y);
        }

        private void initStyleAndStyleGroupFields(int x, int y) {
            final DesignTheme theme = ArchitectManager.getModel().getGroundPlan().theme;
            List<DesignLayer> layers = theme.getLayers();
            final ArrayList<String> styleOptions = new ArrayList<String>();
            layers.forEach(layer -> styleOptions.add(layer.getDisplayName()));
            ScrollArea styleScrollArea = new ScrollArea(styleOptions, new ScrollArea.IScrollAction(){

                @Override
                public void onScroll(int position) {
                    ((GuiComposerPartial)GuiComposerPartial.this).cuboid.designLayer = theme.getLayers().get(position);
                    ((GuiComposerPartial)GuiComposerPartial.this).style.text = (String)styleOptions.get(position);
                }
            });
            styleScrollArea.setBounds(x + 75, y + 12, 70, 14);
            styleScrollArea.setTitle("Build style");
            styleScrollArea.setState(layers.indexOf((Object)this.cuboid.designLayer));
            this.style.text = this.cuboid.designLayer.getDisplayName();
            this.scrollAreas.add(styleScrollArea);
            ArrayList paletteOptions = Lists.newArrayList((Object[])new String[]{"Primary", "Secondary"});
            ScrollArea palleteScrollArea = new ScrollArea(paletteOptions, new ScrollArea.IScrollAction(){

                @Override
                public void onScroll(int position) {
                    ((GuiComposerPartial)GuiComposerPartial.this).cuboid.secondaryPalette = position == 1;
                    ((GuiComposerPartial)GuiComposerPartial.this).paletteGroup.text = ((GuiComposerPartial)GuiComposerPartial.this).cuboid.secondaryPalette ? "2nd" : "1st";
                }
            });
            palleteScrollArea.setBounds(x + 87, y + 32, 30, 14);
            palleteScrollArea.setTitle("Palette used");
            palleteScrollArea.setState(this.cuboid.secondaryPalette ? 1 : 0);
            this.paletteGroup.text = this.cuboid.secondaryPalette ? "2nd" : "1st";
            this.scrollAreas.add(palleteScrollArea);
            ScrollArea styleGroupScrollArea = new ScrollArea(0, 5, new ScrollArea.IScrollAction(){

                @Override
                public void onScroll(int position) {
                    char groupChar = position < 4 ? (char)(position + 65) : (char)'U';
                    ((GuiComposerPartial)GuiComposerPartial.this).cuboid.styleGroup = groupChar;
                    ((GuiComposerPartial)GuiComposerPartial.this).styleGroup.text = "" + groupChar;
                }
            });
            styleGroupScrollArea.setBounds(x + 123, y + 32, 22, 14);
            styleGroupScrollArea.setTitle("Style group");
            styleGroupScrollArea.setState(this.cuboid.styleGroup >= 'A' && this.cuboid.styleGroup <= 'D' ? this.cuboid.styleGroup - 65 : 5);
            this.styleGroup.text = "" + (styleGroupScrollArea.getState() < 4 ? (char)(styleGroupScrollArea.getState() + 65) : (char)'U');
            this.scrollAreas.add(styleGroupScrollArea);
        }

        private void initPosAndSizeFields(int x, int y) {
            int coordinate;
            int i;
            this.labelPosition.addElement(new DynamicLabel(x + 179, y + 15));
            this.labelPosition.addElement(new DynamicLabel(x + 203, y + 15));
            this.labelPosition.addElement(new DynamicLabel(x + 227, y + 15));
            this.labelSize.addElement(new DynamicLabel(x + 179, y + 35));
            this.labelSize.addElement(new DynamicLabel(x + 203, y + 35));
            this.labelSize.addElement(new DynamicLabel(x + 227, y + 35));
            Vector<Integer> pos = new Vector<Integer>(3);
            pos.addElement(this.cuboid.x);
            pos.addElement(this.cuboid.y);
            pos.addElement(this.cuboid.z);
            Vector<Integer> size = new Vector<Integer>(3);
            size.addElement(this.cuboid.width);
            size.addElement(this.cuboid.height);
            size.addElement(this.cuboid.length);
            this.scrollAreaPosition = new Vector(3);
            this.scrollAreaSize = new Vector(3);
            boolean X = false;
            boolean Y = true;
            int Z = 2;
            for (i = 0; i < 3; ++i) {
                coordinate = i;
                ScrollArea scrollArea = new ScrollArea((Integer)pos.elementAt(i) - 50, (Integer)pos.elementAt(i) + 50, new ScrollArea.IScrollAction(){

                    @Override
                    public void onScroll(int position) {
                        switch (coordinate) {
                            case 0: {
                                int diff = position - ((GuiComposerPartial)GuiComposerPartial.this).cuboid.x;
                                GuiComposer.this.stack.forRoomAndEachAbove(GuiComposerPartial.this.cuboid, room -> room.x += diff);
                                break;
                            }
                            case 1: {
                                int diff = position - ((GuiComposerPartial)GuiComposerPartial.this).cuboid.y;
                                GuiComposer.this.stack.forRoomAndEachAbove(GuiComposerPartial.this.cuboid, room -> room.y += diff);
                                break;
                            }
                            case 2: {
                                int diff = position - ((GuiComposerPartial)GuiComposerPartial.this).cuboid.z;
                                GuiComposer.this.stack.forRoomAndEachAbove(GuiComposerPartial.this.cuboid, room -> room.z += diff);
                            }
                        }
                        GuiComposerPartial.this.parent.updateAllPositioningLabels();
                    }
                });
                scrollArea.setBounds(x + 176 + 24 * i, y + 12, 22, 14);
                scrollArea.setState((Integer)pos.elementAt(i));
                scrollArea.setTitle("Change Position");
                scrollArea.setNumeric(true);
                this.labelPosition.elementAt((int)i).text = ((Integer)pos.elementAt(i)).toString();
                this.scrollAreas.add(scrollArea);
                this.scrollAreaPosition.addElement(scrollArea);
            }
            for (i = 0; i < 3; ++i) {
                coordinate = i;
                boolean vertical = coordinate == 1;
                ScrollArea scrollArea = new ScrollArea(vertical ? 1 : 2, vertical ? 11 : 20, new ScrollArea.ICancelableScrollAction(){

                    @Override
                    public void onScroll(int position) {
                        switch (coordinate) {
                            case 0: {
                                int diff = position * 2 + 1 - ((GuiComposerPartial)GuiComposerPartial.this).cuboid.width;
                                GuiComposer.this.stack.forRoomAndEachAbove(GuiComposerPartial.this.cuboid, room -> {
                                    if (Math.min(room.width + diff, room.length) > GuiComposer.this.stack.getMaxFacadeWidth()) {
                                        return;
                                    }
                                    if (Math.min(room.width + diff, room.length) < GuiComposer.this.stack.getMinWidth()) {
                                        return;
                                    }
                                    if (GuiComposer.this.stack instanceof CylinderStack && room.width + diff > GuiComposer.this.stack.getMaxFacadeWidth()) {
                                        return;
                                    }
                                    if (GuiComposer.this.stack instanceof CylinderStack && room.width + diff < GuiComposer.this.stack.getMinWidth()) {
                                        return;
                                    }
                                    room.width += diff;
                                    room.x += diff / -2;
                                    if (GuiComposer.this.stack instanceof CylinderStack) {
                                        room.length += diff;
                                        room.z += diff / -2;
                                    }
                                });
                                GuiComposer.this.swapRoofTypeIfNecessary();
                                break;
                            }
                            case 1: {
                                int diff = position - ((GuiComposerPartial)GuiComposerPartial.this).cuboid.height;
                                ((GuiComposerPartial)GuiComposerPartial.this).cuboid.height += diff;
                                GuiComposer.this.stack.forEachAbove(GuiComposerPartial.this.cuboid, room -> room.y += diff);
                                break;
                            }
                            case 2: {
                                int diff = position * 2 + 1 - ((GuiComposerPartial)GuiComposerPartial.this).cuboid.length;
                                GuiComposer.this.stack.forRoomAndEachAbove(GuiComposerPartial.this.cuboid, room -> {
                                    if (Math.min(room.width, room.length + diff) > GuiComposer.this.stack.getMaxFacadeWidth()) {
                                        return;
                                    }
                                    if (Math.min(room.width, room.length + diff) < GuiComposer.this.stack.getMinWidth()) {
                                        return;
                                    }
                                    if (GuiComposer.this.stack instanceof CylinderStack && room.width + diff > GuiComposer.this.stack.getMaxFacadeWidth()) {
                                        return;
                                    }
                                    if (GuiComposer.this.stack instanceof CylinderStack && room.width + diff < GuiComposer.this.stack.getMinWidth()) {
                                        return;
                                    }
                                    room.length += diff;
                                    room.z += diff / -2;
                                    if (GuiComposer.this.stack instanceof CylinderStack) {
                                        room.width += diff;
                                        room.x += diff / -2;
                                    }
                                });
                                GuiComposer.this.swapRoofTypeIfNecessary();
                            }
                        }
                        GuiComposerPartial.this.parent.updateAllPositioningLabels();
                    }

                    @Override
                    public boolean canScroll(int position) {
                        switch (coordinate) {
                            case 0: {
                                if (Math.min(position * 2 + 1, ((GuiComposerPartial)GuiComposerPartial.this).cuboid.length) <= GuiComposer.this.stack.getMaxFacadeWidth()) break;
                                return false;
                            }
                            case 2: {
                                if (Math.min(((GuiComposerPartial)GuiComposerPartial.this).cuboid.width, position * 2 + 1) <= GuiComposer.this.stack.getMaxFacadeWidth()) break;
                                return false;
                            }
                        }
                        return true;
                    }
                });
                scrollArea.setBounds(x + 176 + 24 * i, y + 32, 22, 14);
                scrollArea.setTitle("Change Size");
                scrollArea.setState(i == 1 ? (Integer)size.elementAt(i) : ((Integer)size.elementAt(i) - 1) / 2);
                scrollArea.setNumeric(true);
                this.labelSize.elementAt((int)i).text = ((Integer)size.elementAt(i)).toString();
                this.scrollAreas.add(scrollArea);
                this.scrollAreaSize.addElement(scrollArea);
            }
        }

        public void updatePositioningLabels() {
            Vector<Integer> pos = new Vector<Integer>(3);
            pos.addElement(this.cuboid.x);
            pos.addElement(this.cuboid.y);
            pos.addElement(this.cuboid.z);
            Vector<Integer> size = new Vector<Integer>(3);
            size.addElement(this.cuboid.width);
            size.addElement(this.cuboid.height);
            size.addElement(this.cuboid.length);
            for (int i = 0; i < 3; ++i) {
                this.labelPosition.elementAt((int)i).text = ((Integer)pos.elementAt(i)).toString();
                this.labelSize.elementAt((int)i).text = ((Integer)size.elementAt(i)).toString();
                this.scrollAreaPosition.elementAt(i).setState((Integer)pos.elementAt(i));
                this.scrollAreaSize.elementAt(i).setState(i == 1 ? (Integer)size.elementAt(i) : ((Integer)size.elementAt(i) - 1) / 2);
            }
        }

        public void drawScreen(int yOffset, int mouseX, int mouseY, float partialTicks) {
            int x = this.parent.xTopLeft;
            int y = this.parent.yTopLeft + yOffset;
            GuiResources.COMPOSER.draw(this.parent, x, y);
            GuiComposer.this.func_73731_b(GuiComposer.this.field_146289_q, "" + (this.layer + 1), x + 10, y + 15, 0xCCDDFF);
            GuiComposer.this.field_146289_q.func_175065_a("Type", (float)(x + 32), (float)(y + 15), 5726074, false);
            GuiComposer.this.field_146289_q.func_175065_a("Style", (float)(x + 32), (float)(y + 35), 5726074, false);
            this.style.draw(this.parent);
            this.styleGroup.draw(this.parent);
            this.paletteGroup.draw(this.parent);
            for (int i = 0; i < 3; ++i) {
                this.labelPosition.elementAt(i).draw(this.parent);
                this.labelSize.elementAt(i).draw(this.parent);
            }
        }
    }
}

