/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.gui.GuiResources;
import com.simibubi.mightyarchitect.gui.widgets.DynamicLabel;
import com.simibubi.mightyarchitect.gui.widgets.ScrollArea;
import com.simibubi.mightyarchitect.networking.PacketNbt;
import com.simibubi.mightyarchitect.networking.PacketSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiDesignExporter
extends GuiScreen {
    private int xSize;
    private int ySize;
    private int xTopLeft;
    private int yTopLeft;
    private List<ScrollArea> scrollAreas;
    private ScrollArea scrollAreaTheme;
    private ScrollArea scrollAreaLayer;
    private ScrollArea scrollAreaType;
    private ScrollArea scrollAreaAdditionalData;
    private DynamicLabel labelTheme;
    private DynamicLabel labelLayer;
    private DynamicLabel labelType;
    private DynamicLabel labelAdditionalData;
    private String additionalDataKey;
    private int additionalDataValue;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xSize = GuiResources.EXPORTER.width;
        this.ySize = GuiResources.EXPORTER.height;
        this.xTopLeft = (this.field_146294_l - this.xSize) / 2;
        this.yTopLeft = (this.field_146295_m - this.ySize) / 2;
        DesignTheme theme = DesignTheme.Medieval;
        DesignLayer layer = DesignLayer.Independent;
        DesignType type = DesignType.WALL;
        this.additionalDataValue = -1;
        ItemStack heldItem = this.field_146297_k.field_71439_g.func_184614_ca();
        if (heldItem.func_77942_o()) {
            NBTTagCompound tag = heldItem.func_77978_p();
            if (tag.func_74764_b("Theme")) {
                theme = DesignTheme.valueOf(tag.func_74779_i("Theme"));
            }
            if (tag.func_74764_b("Layer")) {
                layer = DesignLayer.valueOf(tag.func_74779_i("Layer"));
            }
            if (tag.func_74764_b("Type")) {
                type = DesignType.valueOf(tag.func_74779_i("Type"));
            }
            if (tag.func_74764_b("Additional")) {
                this.additionalDataValue = tag.func_74762_e("Additional");
            }
        }
        this.labelTheme = new DynamicLabel(this.xTopLeft + 96, this.yTopLeft + 28);
        this.labelLayer = new DynamicLabel(this.xTopLeft + 96, this.yTopLeft + 48);
        this.labelType = new DynamicLabel(this.xTopLeft + 96, this.yTopLeft + 68);
        this.labelAdditionalData = new DynamicLabel(this.xTopLeft + 96, this.yTopLeft + 88);
        this.scrollAreas = new LinkedList<ScrollArea>();
        this.additionalDataKey = "";
        this.initScrollAreas(theme, layer, type);
    }

    private void initScrollAreas(DesignTheme theme, DesignLayer layer, DesignType type) {
        List<DesignType> types;
        this.scrollAreas.clear();
        ImmutableList themes = ImmutableList.copyOf((Object[])DesignTheme.values());
        final List<DesignLayer> layers = theme.getLayers();
        if (!layers.contains((Object)layer)) {
            layer = DesignLayer.Independent;
        }
        if (!(types = theme.getTypes()).contains((Object)type)) {
            type = DesignType.WALL;
        }
        final ArrayList<String> layerOptions = new ArrayList<String>();
        layers.forEach(l -> layerOptions.add(l.getDisplayName()));
        this.scrollAreaLayer = new ScrollArea(layerOptions, new ScrollArea.IScrollAction(){

            @Override
            public void onScroll(int position) {
                ((GuiDesignExporter)GuiDesignExporter.this).labelLayer.text = (String)layerOptions.get(position);
            }
        });
        this.scrollAreaLayer.setBounds(this.xTopLeft + 93, this.yTopLeft + 45, 70, 14);
        this.scrollAreaLayer.setTitle("Style Layer");
        this.scrollAreaLayer.setState(layers.indexOf((Object)layer));
        this.labelLayer.text = layer.getDisplayName();
        this.scrollAreas.add(this.scrollAreaLayer);
        final ArrayList<String> typeOptions = new ArrayList<String>();
        types.forEach(t -> typeOptions.add(t.getDisplayName()));
        this.scrollAreaType = new ScrollArea(typeOptions, new ScrollArea.IScrollAction(){

            @Override
            public void onScroll(int position) {
                ((GuiDesignExporter)GuiDesignExporter.this).labelType.text = (String)typeOptions.get(position);
                GuiDesignExporter.this.initAdditionalDataScrollArea((DesignType)((Object)types.get(position)));
            }
        });
        this.scrollAreaType.setBounds(this.xTopLeft + 93, this.yTopLeft + 65, 70, 14);
        this.scrollAreaType.setTitle("Design Type");
        this.scrollAreaType.setState(types.indexOf((Object)type));
        this.labelType.text = type.getDisplayName();
        this.scrollAreas.add(this.scrollAreaType);
        final ArrayList<String> themeOptions = new ArrayList<String>();
        themes.forEach(t -> themeOptions.add(t.getDisplayName()));
        this.scrollAreaTheme = new ScrollArea(themeOptions, new ScrollArea.IScrollAction(){

            @Override
            public void onScroll(int position) {
                ((GuiDesignExporter)GuiDesignExporter.this).labelTheme.text = (String)themeOptions.get(position);
                GuiDesignExporter.this.initScrollAreas(DesignTheme.values()[position], (DesignLayer)((Object)layers.get(GuiDesignExporter.this.scrollAreaLayer.getState())), (DesignType)((Object)types.get(GuiDesignExporter.this.scrollAreaType.getState())));
            }
        });
        this.scrollAreaTheme.setBounds(this.xTopLeft + 93, this.yTopLeft + 25, 70, 14);
        this.scrollAreaTheme.setTitle("Theme");
        this.scrollAreaTheme.setState(themes.indexOf((Object)theme));
        this.labelTheme.text = theme.getDisplayName();
        this.scrollAreas.add(this.scrollAreaTheme);
        this.initAdditionalDataScrollArea(type);
    }

    private void initAdditionalDataScrollArea(DesignType type) {
        if (type.hasAdditionalData()) {
            this.additionalDataKey = type.getAdditionalDataName();
            if (type.hasSizeData()) {
                if (this.additionalDataValue == -1) {
                    this.additionalDataValue = 1;
                }
                this.labelAdditionalData.text = this.additionalDataValue + "m";
                this.scrollAreaAdditionalData = new ScrollArea(1, 32, new ScrollArea.IScrollAction(){

                    @Override
                    public void onScroll(int position) {
                        GuiDesignExporter.this.additionalDataValue = position;
                        ((GuiDesignExporter)GuiDesignExporter.this).labelAdditionalData.text = position + "m";
                    }
                });
                this.scrollAreaAdditionalData.setNumeric(true);
            } else if (type.hasSubtypes()) {
                List<String> subtypeOptions;
                if (this.additionalDataValue == -1) {
                    this.additionalDataValue = 0;
                }
                if (this.additionalDataValue >= (subtypeOptions = type.getSubtypeOptions()).size()) {
                    this.additionalDataValue = 0;
                }
                this.labelAdditionalData.text = subtypeOptions.get(this.additionalDataValue);
                this.scrollAreaAdditionalData = new ScrollArea(subtypeOptions, new ScrollArea.IScrollAction(){

                    @Override
                    public void onScroll(int position) {
                        GuiDesignExporter.this.additionalDataValue = position;
                        ((GuiDesignExporter)GuiDesignExporter.this).labelAdditionalData.text = (String)subtypeOptions.get(position);
                    }
                });
                this.scrollAreaAdditionalData.setNumeric(false);
            }
            this.scrollAreaAdditionalData.setTitle(this.additionalDataKey);
            this.scrollAreaAdditionalData.setBounds(this.xTopLeft + 93, this.yTopLeft + 85, 70, 14);
            this.scrollAreaAdditionalData.setState(this.additionalDataValue);
        } else {
            this.additionalDataValue = -1;
            this.additionalDataKey = "";
            this.labelAdditionalData.text = "";
            this.scrollAreaAdditionalData = null;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GuiResources.EXPORTER.draw(this, this.xTopLeft, this.yTopLeft);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int color = 5726074;
        this.field_146289_q.func_175065_a("Export custom Designs", (float)(this.xTopLeft + 10), (float)(this.yTopLeft + 10), color, false);
        this.field_146289_q.func_175065_a("Theme / Style", (float)(this.xTopLeft + 10), (float)(this.yTopLeft + 28), color, false);
        this.field_146289_q.func_175065_a("Building Layer", (float)(this.xTopLeft + 10), (float)(this.yTopLeft + 48), color, false);
        this.field_146289_q.func_175065_a("Design Type", (float)(this.xTopLeft + 10), (float)(this.yTopLeft + 68), color, false);
        this.field_146289_q.func_175065_a(this.additionalDataKey, (float)(this.xTopLeft + 10), (float)(this.yTopLeft + 88), color, false);
        this.labelTheme.draw(this);
        this.labelLayer.draw(this);
        this.labelType.draw(this);
        this.labelAdditionalData.draw(this);
        this.scrollAreas.forEach(area -> area.draw(this, mouseX, mouseY));
        if (this.scrollAreaAdditionalData != null) {
            this.scrollAreaAdditionalData.draw(this, mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        ItemStack heldItemMainhand = this.field_146297_k.field_71439_g.func_184614_ca();
        NBTTagCompound nbt = new NBTTagCompound();
        DesignTheme chosenTheme = DesignTheme.values()[this.scrollAreaTheme.getState()];
        nbt.func_74778_a("Theme", chosenTheme.name());
        nbt.func_74778_a("Layer", chosenTheme.getLayers().get(this.scrollAreaLayer.getState()).name());
        nbt.func_74778_a("Type", chosenTheme.getTypes().get(this.scrollAreaType.getState()).name());
        if (this.additionalDataValue != -1) {
            nbt.func_74768_a("Additional", this.additionalDataValue);
        }
        heldItemMainhand.func_77982_d(nbt);
        PacketSender.INSTANCE.sendToServer((IMessage)new PacketNbt(heldItemMainhand));
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int scrollAmount = (mouseButton == 0 ? -1 : 1) * (Keyboard.isKeyDown((int)42) ? 5 : 1);
        this.scrollAreas.forEach(area -> area.tryScroll(mouseX, mouseY, scrollAmount));
        if (this.scrollAreaAdditionalData != null) {
            this.scrollAreaAdditionalData.tryScroll(mouseX, mouseY, scrollAmount);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            int amount = (int)((float)scroll / -120.0f);
            this.scrollAreas.forEach(area -> area.tryScroll(i, j, amount));
            if (this.scrollAreaAdditionalData != null) {
                this.scrollAreaAdditionalData.tryScroll(i, j, amount);
            }
        }
    }
}

