/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.SchematicHologram;
import com.simibubi.mightyarchitect.control.palette.Palette;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.palette.PaletteStorage;
import com.simibubi.mightyarchitect.gui.GuiResources;
import com.simibubi.mightyarchitect.gui.widgets.SimiButton;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class GuiPalettePicker
extends GuiScreen {
    private int xSize;
    private int ySize;
    private int xTopLeft;
    private int yTopLeft;
    private PaletteButton primary;
    private PaletteButton secondary;

    public GuiPalettePicker() {
        this.field_146297_k = Minecraft.func_71410_x();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xSize = 256;
        this.ySize = 236;
        this.xTopLeft = (this.field_146294_l - this.xSize) / 2;
        this.yTopLeft = (this.field_146295_m - this.ySize) / 2;
        this.updateSelected();
        int id = 2;
        int x = this.xTopLeft + 7;
        int y = this.yTopLeft + 68;
        for (String paletteName : PaletteStorage.getResourcePaletteNames()) {
            this.field_146292_n.add(new PaletteButton(PaletteStorage.getPalette(paletteName), this, id, x + (id - 2) % 5 * 23, y + (id - 2) / 5 * 23));
            ++id;
        }
        int i = 0;
        x = this.xTopLeft + 134;
        y = this.yTopLeft + 68;
        for (String paletteName : PaletteStorage.getPaletteNames()) {
            this.field_146292_n.add(new PaletteButton(PaletteStorage.getPalette(paletteName), this, id + i, x + i % 5 * 23, y + i / 5 * 23));
            ++i;
        }
        this.func_189646_b(new SimiButton(id + i, x + 1 + i % 5 * 23, y + 1 + i / 5 * 23, GuiResources.ICON_ADD));
        ++i;
    }

    private void updateSelected() {
        if (this.field_146292_n.contains((Object)this.primary)) {
            this.field_146292_n.remove((Object)this.primary);
        }
        if (this.field_146292_n.contains((Object)this.secondary)) {
            this.field_146292_n.remove((Object)this.secondary);
        }
        this.primary = new PaletteButton(ArchitectManager.getModel().getPrimary(), this, 0, this.xTopLeft + 134, this.yTopLeft + 6);
        this.secondary = new PaletteButton(ArchitectManager.getModel().getSecondary(), this, 1, this.xTopLeft + 191, this.yTopLeft + 6);
        this.primary.field_146124_l = false;
        this.secondary.field_146124_l = false;
        this.field_146292_n.add(this.primary);
        this.field_146292_n.add(this.secondary);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GuiResources.PALETTES.draw(this, this.xTopLeft, this.yTopLeft);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int color = 5726074;
        this.field_146289_q.func_175065_a("Palette Picker", (float)(this.xTopLeft + 8), (float)(this.yTopLeft + 10), color, false);
        this.field_146289_q.func_175065_a("Included Palettes", (float)(this.xTopLeft + 8), (float)(this.yTopLeft + 53), color, false);
        this.field_146289_q.func_175065_a("My Palettes", (float)(this.xTopLeft + 134), (float)(this.yTopLeft + 53), color, false);
        this.field_146289_q.func_175065_a("Primary", (float)(this.xTopLeft + 134), (float)(this.yTopLeft + 30), color, false);
        this.field_146289_q.func_175065_a("Secondary", (float)(this.xTopLeft + 191), (float)(this.yTopLeft + 30), color, false);
        for (GuiButton button : this.field_146292_n) {
            button.func_146111_b(mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 1) {
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                this.field_146290_a = guibutton;
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.actionRightClickPerformed(guibutton);
            }
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof SimiButton) {
            ArchitectManager.createPalette(true);
            this.field_146297_k.func_147108_a(null);
        } else {
            ArchitectManager.getModel().swapPrimaryPalette(((PaletteButton)button).palette);
            this.updateSelected();
            SchematicHologram.getInstance().schematicChanged();
        }
    }

    private void actionRightClickPerformed(GuiButton button) {
        if (button instanceof SimiButton) {
            ArchitectManager.createPalette(false);
            this.field_146297_k.func_147108_a(null);
        } else {
            ArchitectManager.getModel().swapSecondaryPalette(((PaletteButton)button).palette);
            this.updateSelected();
            SchematicHologram.getInstance().schematicChanged();
        }
    }

    class PaletteButton
    extends GuiButton {
        GuiScreen parent;
        PaletteDefinition palette;

        public PaletteButton(PaletteDefinition palette, GuiScreen parent, int buttonId, int x, int y) {
            super(buttonId, x, y, 20, 20, "");
            this.parent = parent;
            this.palette = palette;
            this.field_146125_m = true;
            this.field_146124_l = true;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            GuiResources.PALETTE_BUTTON.draw(this.parent, this.field_146128_h, this.field_146129_i);
            this.drawPreview(mc);
        }

        private void drawPreview(Minecraft mc) {
            GlStateManager.func_179094_E();
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179147_l();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179109_b((float)((float)this.field_146128_h + 4.5f), (float)((float)this.field_146129_i + 16.5f), (float)20.0f);
            GlStateManager.func_179114_b((float)-22.5f, (float)0.3f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)7.0f, (float)-7.0f, (float)7.0f);
            GlStateManager.func_179103_j((int)7425);
            mc.func_175602_ab().func_175018_a(this.palette.get(Palette.INNER_PRIMARY, EnumFacing.UP), new BlockPos(0, 0, 0), (IBlockAccess)mc.field_71441_e, buffer);
            mc.func_175602_ab().func_175018_a(this.palette.get(Palette.INNER_DETAIL, EnumFacing.UP), new BlockPos(1, 0, 0), (IBlockAccess)mc.field_71441_e, buffer);
            mc.func_175602_ab().func_175018_a(this.palette.get(Palette.HEAVY_PRIMARY, EnumFacing.UP), new BlockPos(0, 1, 0), (IBlockAccess)mc.field_71441_e, buffer);
            mc.func_175602_ab().func_175018_a(this.palette.get(Palette.ROOF_PRIMARY, EnumFacing.UP), new BlockPos(1, 1, 0), (IBlockAccess)mc.field_71441_e, buffer);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }

        public void func_146111_b(int mouseX, int mouseY) {
            if (mouseX >= this.field_146128_h && mouseX <= this.field_146128_h + 20 && mouseY >= this.field_146129_i && mouseY <= this.field_146129_i + 20) {
                GuiPalettePicker.this.func_146279_a(this.palette.getName(), mouseX, mouseY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

