/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.gui.widgets;

import com.google.common.base.Optional;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class ScrollArea
extends Gui {
    private int x;
    private int y;
    private int width;
    private int height;
    private IScrollAction action;
    public boolean enabled = true;
    private int currentState;
    private Optional<List<String>> tooltipContent;
    private List<String> tooltip;
    private String title = "Choose an option";
    private int min;
    private int max;
    private boolean limitless;
    private boolean numeric;

    public ScrollArea(List<String> options, IScrollAction action) {
        this(0, options.size(), action);
        this.tooltipContent = Optional.of(options);
        this.updateTooltip();
    }

    public ScrollArea(int min, int max, IScrollAction action) {
        this(action);
        this.limitless = false;
        this.min = min;
        this.max = max;
    }

    public ScrollArea(IScrollAction action) {
        this.action = action;
        this.tooltipContent = Optional.absent();
        this.limitless = true;
        this.numeric = false;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setState(int state) {
        this.currentState = state;
        this.updateTooltip();
    }

    public int getState() {
        return this.currentState;
    }

    public boolean isHovered(int x, int y) {
        return x > this.x && x < this.x + this.width && y > this.y && y < this.y + this.height;
    }

    public void tryScroll(int mouseX, int mouseY, int amount) {
        if (this.enabled && this.isHovered(mouseX, mouseY)) {
            this.scroll(this.numeric ? -amount : amount);
        }
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    private void scroll(int amount) {
        if (this.enabled) {
            if (this.limitless) {
                if (!(this.action instanceof ICancelableScrollAction) || ((ICancelableScrollAction)this.action).canScroll(amount)) {
                    this.action.onScroll(amount);
                }
                return;
            }
            if (!(this.action instanceof ICancelableScrollAction) || ((ICancelableScrollAction)this.action).canScroll(this.currentState + amount)) {
                this.currentState += amount;
                if (this.currentState < this.min) {
                    this.currentState = this.min;
                }
                if (this.currentState >= this.max) {
                    this.currentState = this.max - 1;
                }
                this.updateTooltip();
                this.action.onScroll(this.currentState);
            }
        }
    }

    public void draw(GuiScreen screen, int mouseX, int mouseY) {
        GlStateManager.func_179123_a();
        if (this.enabled && this.isHovered(mouseX, mouseY)) {
            if (this.tooltipContent.isPresent()) {
                screen.func_146283_a(this.getToolTip(), mouseX, mouseY);
            } else {
                screen.func_146279_a(ChatFormatting.RED + this.title, mouseX, mouseY);
            }
        }
        GlStateManager.func_179099_b();
    }

    public List<String> getToolTip() {
        return this.tooltip;
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.tooltip = new LinkedList<String>();
        this.tooltip.add(ChatFormatting.RED + this.title);
        if (this.tooltipContent.isPresent()) {
            for (int i = this.min; i < this.max; ++i) {
                StringBuilder result = new StringBuilder();
                if (i == this.currentState) {
                    result.append(ChatFormatting.WHITE).append("-> ").append((String)((List)this.tooltipContent.get()).get(i));
                } else {
                    result.append(ChatFormatting.GRAY).append("> ").append((String)((List)this.tooltipContent.get()).get(i));
                }
                this.tooltip.add(result.toString());
            }
        }
    }

    public static interface ICancelableScrollAction
    extends IScrollAction {
        @Override
        public void onScroll(int var1);

        public boolean canScroll(int var1);
    }

    public static interface IScrollAction {
        public void onScroll(int var1);
    }
}

