/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketInstantPrint
implements IMessage {
    private BunchOfBlocks blocks;

    public PacketInstantPrint() {
    }

    public PacketInstantPrint(BunchOfBlocks blocks) {
        this.blocks = blocks;
    }

    public void fromBytes(ByteBuf buf) {
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound blockTag = ByteBufUtils.readTag((ByteBuf)buf);
            NBTTagCompound posTag = ByteBufUtils.readTag((ByteBuf)buf);
            blocks.put(NBTUtil.func_186861_c((NBTTagCompound)posTag), NBTUtil.func_190008_d((NBTTagCompound)blockTag));
        }
        this.blocks = new BunchOfBlocks(blocks);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blocks.size);
        this.blocks.blocks.forEach((pos, state) -> {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)state));
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_186859_a((BlockPos)pos));
        });
    }

    public static List<PacketInstantPrint> sendSchematic(Map<BlockPos, IBlockState> blockMap, BlockPos anchor) {
        LinkedList<PacketInstantPrint> packets = new LinkedList<PacketInstantPrint>();
        HashMap<Object, Object> currentMap = new HashMap<BlockPos, IBlockState>(32);
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(blockMap.keySet());
        for (int i = 0; i < blockMap.size(); ++i) {
            if (currentMap.size() >= 32) {
                packets.add(new PacketInstantPrint(new BunchOfBlocks(currentMap)));
                currentMap = new HashMap(32);
            }
            currentMap.put(((BlockPos)posList.get(i)).func_177971_a((Vec3i)anchor), blockMap.get(posList.get(i)));
        }
        packets.add(new PacketInstantPrint(new BunchOfBlocks(currentMap)));
        return packets;
    }

    public static class PacketHandlerInstantPrint
    implements IMessageHandler<PacketInstantPrint, IMessage> {
        public IMessage onMessage(PacketInstantPrint message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> ((PacketInstantPrint)message).blocks.blocks.forEach((pos, state) -> player.func_130014_f_().func_175656_a(pos, state)));
            return null;
        }
    }

    static class BunchOfBlocks {
        static final int MAX_SIZE = 32;
        Map<BlockPos, IBlockState> blocks;
        int size;

        public BunchOfBlocks(Map<BlockPos, IBlockState> blocks) {
            this.blocks = blocks;
            this.size = blocks.size();
        }
    }
}

