/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control;

import com.simibubi.mightyarchitect.AllPackets;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.control.Schematic;
import com.simibubi.mightyarchitect.control.SchematicHologram;
import com.simibubi.mightyarchitect.control.TemplateBlockAccess;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.design.DesignExporter;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.ThemeStorage;
import com.simibubi.mightyarchitect.control.helpful.FilesHelper;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import com.simibubi.mightyarchitect.control.palette.PaletteStorage;
import com.simibubi.mightyarchitect.control.phase.ArchitectPhases;
import com.simibubi.mightyarchitect.control.phase.IArchitectPhase;
import com.simibubi.mightyarchitect.control.phase.IDrawBlockHighlights;
import com.simibubi.mightyarchitect.control.phase.IRenderGameOverlay;
import com.simibubi.mightyarchitect.gui.ArchitectMenuScreen;
import com.simibubi.mightyarchitect.gui.DesignExporterScreen;
import com.simibubi.mightyarchitect.gui.PalettePickerScreen;
import com.simibubi.mightyarchitect.gui.ScreenHelper;
import com.simibubi.mightyarchitect.gui.TextInputPromptScreen;
import com.simibubi.mightyarchitect.gui.ThemeSettingsScreen;
import com.simibubi.mightyarchitect.networking.InstantPrintPacket;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ArchitectManager {
    private static ArchitectPhases phase = ArchitectPhases.Empty;
    private static Schematic model = new Schematic();
    private static ArchitectMenuScreen menu = new ArchitectMenuScreen();
    public static boolean testRun = false;

    public static void compose() {
        ArchitectManager.enterPhase(ArchitectPhases.Composing);
    }

    public static void compose(DesignTheme theme) {
        if (ArchitectManager.getModel().isEmpty()) {
            ArchitectManager.getModel().setGroundPlan(new GroundPlan(theme));
        }
        ArchitectManager.enterPhase(ArchitectPhases.Composing);
    }

    public static void pauseCompose() {
        ArchitectManager.status("Composer paused, use /compose to return.");
    }

    public static void unload() {
        if (!model.isEmpty()) {
            model.getTheme().getDesignPicker().reset();
        }
        ArchitectManager.enterPhase(ArchitectPhases.Empty);
        ArchitectManager.resetSchematic();
        if (testRun) {
            testRun = false;
            ArchitectManager.editTheme(DesignExporter.theme);
        } else {
            menu.setVisible(false);
        }
    }

    public static void design() {
        GroundPlan groundPlan = model.getGroundPlan();
        if (groundPlan.isEmpty()) {
            ArchitectManager.status("Draw some rooms before going to the next step!");
            return;
        }
        model.setSketch(groundPlan.theme.getDesignPicker().assembleSketch(groundPlan, ArchitectManager.model.seed));
        ArchitectManager.enterPhase(ArchitectPhases.Previewing);
    }

    public static void reAssemble() {
        GroundPlan groundPlan = model.getGroundPlan();
        model.setSketch(groundPlan.theme.getDesignPicker().assembleSketch(groundPlan, ArchitectManager.model.seed));
        SchematicHologram.getInstance().schematicChanged();
    }

    public static void createPalette(boolean primary) {
        ArchitectManager.getModel().startCreatingNewPalette(primary);
        ArchitectManager.enterPhase(ArchitectPhases.CreatingPalette);
    }

    public static void finishPalette(String name) {
        if (name.isEmpty()) {
            name = "My Palette";
        }
        PaletteDefinition palette = ArchitectManager.getModel().getCreatedPalette();
        palette.setName(name);
        PaletteStorage.exportPalette(palette);
        PaletteStorage.loadAllPalettes();
        ArchitectManager.getModel().applyCreatedPalette();
        ArchitectManager.status("Your new palette has been saved.");
        ArchitectManager.enterPhase(ArchitectPhases.Previewing);
    }

    public static void print() {
        if (ArchitectManager.getModel().getSketch() == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71356_B()) {
            for (InstantPrintPacket packet : ArchitectManager.getModel().getPackets()) {
                AllPackets.channel.sendToServer((Object)packet);
            }
            SchematicHologram.reset();
            ArchitectManager.status("Printed result into world.");
            ArchitectManager.unload();
        } else {
            ArchitectManager.enterPhase(ArchitectPhases.PrintingToMultiplayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToFile(String name) {
        String filepath;
        block8: {
            if (ArchitectManager.getModel().getSketch() == null) {
                return;
            }
            if (name.isEmpty()) {
                name = "My Build";
            }
            String folderPath = "schematics";
            FilesHelper.createFolderIfMissing(folderPath);
            String filename = FilesHelper.findFirstValidFilename(name, folderPath, "nbt");
            filepath = folderPath + "/" + filename;
            OutputStream outputStream = null;
            try {
                outputStream = Files.newOutputStream(Paths.get(filepath, new String[0]), StandardOpenOption.CREATE);
                CompoundNBT nbttagcompound = ArchitectManager.getModel().writeToTemplate().func_189552_a(new CompoundNBT());
                CompressedStreamTools.func_74799_a((CompoundNBT)nbttagcompound, (OutputStream)outputStream);
                if (outputStream == null) break block8;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block8;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            break block8;
            finally {
                if (outputStream != null) {
                    IOUtils.closeQuietly(outputStream);
                }
            }
        }
        ArchitectManager.status("Saved as " + filepath);
        BlockPos pos = model.getAnchor().func_177971_a((Vec3i)((TemplateBlockAccess)model.getMaterializedSketch()).getBounds().getOrigin());
        StringTextComponent component = new StringTextComponent("Deploy Schematic at: " + TextFormatting.BLUE + "[" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "]");
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)component);
        ArchitectManager.unload();
    }

    public static void status(String message) {
        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent(message), true);
    }

    public static void pickPalette() {
        if (ArchitectManager.getModel().getSketch() == null) {
            return;
        }
        if (ArchitectManager.inPhase(ArchitectPhases.CreatingPalette)) {
            ArchitectManager.getModel().stopPalettePreview();
            ArchitectManager.enterPhase(ArchitectPhases.Previewing);
        }
        ScreenHelper.open(new PalettePickerScreen());
    }

    public static void pickScanPalette() {
        ScreenHelper.open(new PalettePickerScreen(true));
    }

    public static void manageThemes() {
        ArchitectManager.enterPhase(ArchitectPhases.ManagingThemes);
    }

    public static void createTheme() {
        TextInputPromptScreen gui = new TextInputPromptScreen(result -> {
            DesignExporter.setTheme(ThemeStorage.createTheme(result));
            ScreenHelper.open(new ThemeSettingsScreen());
        }, result -> {});
        gui.setButtonTextConfirm("Create");
        gui.setButtonTextAbort("Cancel");
        gui.setTitle("Enter a name for your Theme:");
        ScreenHelper.open(gui);
    }

    public static void editTheme(DesignTheme theme) {
        DesignExporter.setTheme(theme);
        ArchitectManager.enterPhase(ArchitectPhases.EditingThemes);
    }

    public static void changeExportedDesign() {
        ScreenHelper.open(new DesignExporterScreen());
    }

    public static boolean inPhase(ArchitectPhases phase) {
        return ArchitectManager.phase == phase;
    }

    public static void enterPhase(ArchitectPhases newPhase) {
        IArchitectPhase phaseHandler = phase.getPhaseHandler();
        phaseHandler.whenExited();
        phaseHandler = newPhase.getPhaseHandler();
        phaseHandler.whenEntered();
        phase = newPhase;
        menu.updateContents();
    }

    public static Schematic getModel() {
        return model;
    }

    public static ArchitectPhases getPhase() {
        return phase;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            if (!ArchitectManager.inPhase(ArchitectPhases.Paused) && !model.isEmpty()) {
                ArchitectManager.enterPhase(ArchitectPhases.Paused);
            }
            return;
        }
        phase.getPhaseHandler().update();
        menu.onClientTick();
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (phase.getPhaseHandler().onScroll((int)Math.signum(event.getScrollDelta()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            phase.getPhaseHandler().render();
        }
    }

    @SubscribeEvent
    public static void onClick(InputEvent.MouseInputEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        phase.getPhaseHandler().onClick(event.getButton());
    }

    @SubscribeEvent
    public static void onKeyTyped(InputEvent.KeyInputEvent event) {
        if (event.getKey() == 256 && event.getAction() == 1) {
            if (ArchitectManager.inPhase(ArchitectPhases.Composing) || ArchitectManager.inPhase(ArchitectPhases.Previewing)) {
                ArchitectManager.enterPhase(ArchitectPhases.Paused);
                menu.setVisible(false);
            }
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (TheMightyArchitect.COMPOSE.func_151468_f()) {
            if (!menu.isFocused()) {
                ArchitectManager.openMenu();
            }
            return;
        }
        boolean released = event.getAction() == 0;
        phase.getPhaseHandler().onKey(event.getKey(), released);
    }

    public static void openMenu() {
        menu.updateContents();
        ScreenHelper.open(menu);
        menu.setFocused(true);
        menu.setVisible(true);
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        IArchitectPhase phaseHandler = phase.getPhaseHandler();
        if (phaseHandler instanceof IDrawBlockHighlights) {
            ((IDrawBlockHighlights)((Object)phaseHandler)).onBlockHighlight(event);
        }
    }

    @SubscribeEvent
    public static void onDrawGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        IArchitectPhase phaseHandler = phase.getPhaseHandler();
        if (phaseHandler instanceof IRenderGameOverlay) {
            ((IRenderGameOverlay)((Object)phaseHandler)).renderGameOverlay(event);
        }
        menu.drawPassive();
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickBlock event) {
    }

    public static void resetSchematic() {
        model = new Schematic();
    }
}

