/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose;

import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class Room
extends Cuboid {
    public DesignLayer designLayer;
    public DesignType roofType;
    public char styleGroup = (char)65;
    public boolean secondaryPalette;
    public boolean quadFacadeRoof;
    public int layer;

    public Room(BlockPos origin, BlockPos size) {
        this(origin, size.func_177958_n(), size.func_177956_o(), size.func_177952_p());
    }

    public Room(BlockPos origin, int width, int height, int length) {
        super(origin, width, height, length);
        this.designLayer = DesignLayer.Regular;
        this.roofType = DesignType.ROOF;
        this.quadFacadeRoof = Math.abs(width) == Math.abs(length);
        this.secondaryPalette = false;
    }

    @Override
    public Room clone() {
        Room clone = new Room(this.getOrigin(), this.getSize());
        clone.styleGroup = this.styleGroup;
        clone.roofType = this.roofType;
        clone.quadFacadeRoof = this.quadFacadeRoof;
        clone.secondaryPalette = this.secondaryPalette;
        return clone;
    }

    public Room getInterior() {
        Room clone = this.clone();
        ++clone.x;
        ++clone.z;
        clone.width -= 2;
        clone.length -= 2;
        clone.designLayer = this.designLayer;
        clone.secondaryPalette = this.secondaryPalette;
        return clone;
    }

    public Room stack() {
        Room clone = this.clone();
        clone.y += this.height;
        clone.height = Math.max(4, this.height);
        this.roofType = DesignType.NONE;
        this.quadFacadeRoof = false;
        return clone;
    }

    public Direction.Axis getOrientation() {
        return this.width > this.length ? Direction.Axis.X : Direction.Axis.Z;
    }
}

