/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.planner.GroundPlanningToolBase;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.helpful.TessellatorTextures;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class AbstractRoomFaceSelectionTool
extends GroundPlanningToolBase {
    protected boolean highlightRoom;

    @Override
    public void init() {
        super.init();
        this.highlightRoom = true;
    }

    @Override
    protected void makeStacksTransparent(ClientPlayerEntity player, BlockPos hit) {
    }

    @Override
    public void renderTool() {
        if (selectedStack == null) {
            return;
        }
        TessellatorTextures.SelectedRoom.bind();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        selectedStack.forEach(room -> {
            if (room == selectedRoom && this.highlightRoom) {
                return;
            }
            BlockPos pos = room.getOrigin().func_177971_a((Vec3i)ArchitectManager.getModel().getAnchor());
            TessellatorHelper.cube(bufferBuilder, pos, room.getSize(), 0.0625, true, true);
        });
        Tessellator.func_178181_a().func_78381_a();
        if (selectedRoom != null && this.highlightRoom) {
            TessellatorTextures.SuperSelectedRoom.bind();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            BlockPos pos = selectedRoom.getOrigin().func_177971_a((Vec3i)ArchitectManager.getModel().getAnchor());
            TessellatorHelper.cube(bufferBuilder, pos, selectedRoom.getSize(), 0.0625, true, true);
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

