/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.planner.WallDecorationToolBase;
import com.simibubi.mightyarchitect.control.design.DesignPicker;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.helpful.Keyboard;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;

public class CopyDesignTool
extends WallDecorationToolBase {
    protected Design copiedDesign;
    protected DesignType copiedDesignType;
    protected boolean selectingCorners;

    @Override
    public void init() {
        super.init();
        this.copiedDesign = null;
        this.toolModeNoCtrl = "Paste";
        this.toolModeCtrl = "Copy";
        this.highlightRoom = true;
        this.highlightRoof = true;
    }

    @Override
    protected void updateSelectedRooms() {
        super.updateSelectedRooms();
        if (selectedRoom != null) {
            boolean zInCorner = selectedPos.func_177952_p() == CopyDesignTool.selectedRoom.z || selectedPos.func_177952_p() == CopyDesignTool.selectedRoom.z + CopyDesignTool.selectedRoom.length - 1;
            boolean xInCorner = selectedPos.func_177958_n() == CopyDesignTool.selectedRoom.x || selectedPos.func_177958_n() == CopyDesignTool.selectedRoom.x + CopyDesignTool.selectedRoom.width - 1;
            boolean pasting = !Keyboard.isKeyDown(341);
            this.selectingCorners = xInCorner && zInCorner && !(selectedStack instanceof CylinderStack) || this.copiedDesignType == DesignType.CORNER && pasting;
            this.selectingCorners = this.selectingCorners && (this.copiedDesignType != DesignType.WALL || !pasting);
        }
    }

    @Override
    public void renderTool() {
        if (selectedRoom == null) {
            super.renderTool();
            return;
        }
        if (selectedStack instanceof CylinderStack) {
            super.renderTool();
            return;
        }
        if (selectedFace.func_176740_k().func_200128_b()) {
            super.renderTool();
            return;
        }
        GlStateManager.lineWidth((float)5.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableTexture();
        BlockPos origin = selectedRoom.getOrigin().func_177971_a((Vec3i)this.model.getAnchor());
        if (this.selectingCorners) {
            Consumer<BlockPos> renderCorner = pos -> WorldRenderer.func_189694_a((double)((double)pos.func_177958_n() - 0.25), (double)((double)pos.func_177956_o() - 0.0625), (double)((double)pos.func_177952_p() - 0.25), (double)((double)pos.func_177958_n() + 1.25), (double)((double)(pos.func_177956_o() + CopyDesignTool.selectedRoom.height) + 0.125), (double)((double)pos.func_177952_p() + 1.25), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            renderCorner.accept(origin);
            renderCorner.accept(origin.func_177965_g(CopyDesignTool.selectedRoom.width - 1));
            renderCorner.accept(origin.func_177970_e(CopyDesignTool.selectedRoom.length - 1));
            renderCorner.accept(origin.func_177965_g(CopyDesignTool.selectedRoom.width - 1).func_177970_e(CopyDesignTool.selectedRoom.length - 1));
        } else {
            BiConsumer<BlockPos, BlockPos> renderWall = (start, size) -> {
                BlockPos end = start.func_177971_a((Vec3i)size);
                WorldRenderer.func_189694_a((double)((double)start.func_177958_n() - 0.5), (double)((double)start.func_177956_o() - 0.0625), (double)((double)start.func_177952_p() - 0.5), (double)((double)end.func_177958_n() - 0.5), (double)((double)end.func_177956_o() + 0.0625), (double)((double)end.func_177952_p() - 0.5), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            };
            if (selectedFace.func_176740_k() == Direction.Axis.X) {
                renderWall.accept(origin.func_177970_e(1), selectedRoom.getSize().func_177985_f(CopyDesignTool.selectedRoom.width - 1).func_177964_d(1));
                renderWall.accept(origin.func_177965_g(CopyDesignTool.selectedRoom.width).func_177970_e(1), selectedRoom.getSize().func_177985_f(CopyDesignTool.selectedRoom.width - 1).func_177964_d(1));
            } else {
                renderWall.accept(origin.func_177965_g(1), selectedRoom.getSize().func_177964_d(CopyDesignTool.selectedRoom.length - 1).func_177985_f(1));
                renderWall.accept(origin.func_177970_e(CopyDesignTool.selectedRoom.length).func_177965_g(1), selectedRoom.getSize().func_177964_d(CopyDesignTool.selectedRoom.length - 1).func_177985_f(1));
            }
        }
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.enableTexture();
    }

    @Override
    public String handleRightClick() {
        boolean keyDown = Keyboard.isKeyDown(341);
        if (this.copiedDesign == null && !keyDown) {
            return TextFormatting.RED + "Ctrl+Click to copy a Design";
        }
        DesignPicker designPicker = this.model.getTheme().getDesignPicker();
        if (keyDown && selectedRoom != null) {
            if (selectedFace == Direction.UP && selectedRoom == selectedStack.highest()) {
                this.copiedDesign = designPicker.getCachedRoof(selectedStack);
                this.copiedDesignType = selectedStack.getRoofType();
            } else if (this.selectingCorners) {
                this.copiedDesign = designPicker.getCachedRoom((Room)CopyDesignTool.selectedRoom).corner;
                this.copiedDesignType = DesignType.CORNER;
            } else if (selectedStack instanceof CylinderStack) {
                this.copiedDesign = designPicker.getCachedRoom((Room)CopyDesignTool.selectedRoom).wall1;
                this.copiedDesignType = DesignType.TOWER;
            } else {
                DesignPicker.RoomDesignMapping cachedRoom = designPicker.getCachedRoom(selectedRoom);
                this.copiedDesign = selectedFace.func_176740_k() == Direction.Axis.Z ? cachedRoom.wall1 : cachedRoom.wall2;
                this.copiedDesignType = DesignType.WALL;
            }
            return "Copied " + TextFormatting.GREEN + this.copiedDesignType.getDisplayName();
        }
        if (!keyDown && selectedRoom != null) {
            if (DesignType.roofTypes().contains((Object)this.copiedDesignType)) {
                if (selectedStack.getRoofType() != this.copiedDesignType) {
                    return TextFormatting.RED + "Roof types have to match.";
                }
                int facadeWidth = Math.min(CopyDesignTool.selectedStack.highest().width, CopyDesignTool.selectedStack.highest().length);
                if (!this.copiedDesign.fitsHorizontally(facadeWidth)) {
                    return TextFormatting.RED + "Roof does not fit.";
                }
                designPicker.putRoof(selectedStack, this.copiedDesign);
                return this.pasteSuccessful();
            }
            if (this.copiedDesignType == DesignType.TOWER) {
                if (!(selectedStack instanceof CylinderStack)) {
                    return TextFormatting.RED + "Room shapes have to match.";
                }
                if (!this.copiedDesign.fitsHorizontally(CopyDesignTool.selectedRoom.width)) {
                    return TextFormatting.RED + "Target needs to have the same diameter.";
                }
                if (!this.copiedDesign.fitsVertically(CopyDesignTool.selectedRoom.height)) {
                    return TextFormatting.RED + "Design does not fit the targets height.";
                }
                designPicker.putRoom(selectedRoom, new DesignPicker.RoomDesignMapping(this.copiedDesign));
                return this.pasteSuccessful();
            }
            if (this.copiedDesignType == DesignType.CORNER) {
                if (selectedStack instanceof CylinderStack) {
                    return TextFormatting.RED + "Cylinders cannot have corners.";
                }
                if (!this.copiedDesign.fitsVertically(CopyDesignTool.selectedRoom.height)) {
                    return TextFormatting.RED + "Corner Design cannot fit the required height.";
                }
                DesignPicker.RoomDesignMapping priorMapping = designPicker.getCachedRoom(selectedRoom);
                priorMapping.corner = this.copiedDesign;
                designPicker.putRoom(selectedRoom, priorMapping);
                return this.pasteSuccessful();
            }
            if (this.copiedDesignType == DesignType.WALL) {
                int wallWidth;
                if (selectedStack instanceof CylinderStack) {
                    return TextFormatting.RED + "Room shapes have to match.";
                }
                if (selectedFace.func_176740_k().func_200128_b()) {
                    return TextFormatting.RED + "Cannot apply Wall vertically.";
                }
                int n = wallWidth = selectedFace.func_176740_k() == Direction.Axis.Z ? CopyDesignTool.selectedRoom.width - 2 : CopyDesignTool.selectedRoom.length - 2;
                if (!this.copiedDesign.fitsHorizontally(wallWidth)) {
                    return TextFormatting.RED + "Wall Design cannot fit the required width.";
                }
                if (!this.copiedDesign.fitsVertically(CopyDesignTool.selectedRoom.height)) {
                    return TextFormatting.RED + "Wall Design cannot fit the required height.";
                }
                DesignPicker.RoomDesignMapping priorMapping = designPicker.getCachedRoom(selectedRoom);
                if (selectedFace.func_176740_k() == Direction.Axis.Z) {
                    priorMapping.wall1 = this.copiedDesign;
                } else {
                    priorMapping.wall2 = this.copiedDesign;
                }
                designPicker.putRoom(selectedRoom, priorMapping);
                return this.pasteSuccessful();
            }
            return TextFormatting.RED + "Couldn't apply " + this.copiedDesignType.getDisplayName() + " here.";
        }
        return super.handleRightClick();
    }

    private String pasteSuccessful() {
        ArchitectManager.reAssemble();
        return "Applied " + TextFormatting.GREEN + this.copiedDesignType.getDisplayName();
    }
}

