/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.compose.CylinderStack;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.ComposerToolBase;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.helpful.RaycastHelper;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.helpful.TessellatorTextures;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;

public abstract class GroundPlanningToolBase
extends ComposerToolBase {
    protected BlockPos selectedPosition;
    protected Set<Stack> transparentStacks;

    @Override
    public void init() {
        super.init();
        this.selectedPosition = null;
        this.transparentStacks = new HashSet<Stack>();
    }

    @Override
    public void updateSelection() {
        super.updateSelection();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.transparentStacks.clear();
        BlockRayTraceResult trace = RaycastHelper.rayTraceRange(player.field_70170_p, (PlayerEntity)player, 75.0);
        if (trace != null && trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos hit = new BlockPos(trace.func_216347_e());
            this.makeStacksTransparent(player, hit);
            boolean replaceable = player.field_70170_p.func_180495_p(hit).func_196953_a(new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, trace)));
            if (trace.func_216354_b().func_176740_k().func_200128_b() && !replaceable) {
                hit = hit.func_177972_a(trace.func_216354_b());
            }
            this.selectedPosition = this.model.getAnchor() == null ? hit : hit.func_177973_b((Vec3i)this.model.getAnchor());
        } else {
            this.selectedPosition = null;
        }
    }

    protected void makeStacksTransparent(ClientPlayerEntity player, BlockPos hit) {
        if (!this.model.getGroundPlan().isEmpty()) {
            BlockPos target = hit;
            RaycastHelper.rayTraceUntil((PlayerEntity)player, 75.0, pos -> {
                BlockPos localPos = pos.func_177973_b((Vec3i)this.model.getAnchor());
                this.model.getGroundPlan().forEachStack(stack -> {
                    if (stack.getRoomAtPos(localPos) != null) {
                        this.transparentStacks.add((Stack)stack);
                    }
                });
                return pos.equals((Object)target);
            });
        }
    }

    @Override
    public String handleRightClick() {
        if (this.selectedPosition == null) {
            return null;
        }
        if (this.model.getAnchor() == null) {
            this.model.setAnchor(this.selectedPosition);
            this.selectedPosition = BlockPos.field_177992_a;
        }
        return null;
    }

    @Override
    public boolean handleMouseWheel(int scroll) {
        return false;
    }

    @Override
    public void renderGroundPlan() {
        GroundPlan groundPlan = this.model.getGroundPlan();
        BlockPos anchor = this.model.getAnchor();
        if (groundPlan != null && anchor != null) {
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            TessellatorTextures.Trim.bind();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            groundPlan.forEachStack(stack -> stack.forEach(room -> {
                BlockPos pos = room.getOrigin().func_177971_a((Vec3i)anchor);
                TessellatorHelper.walls(bufferBuilder, pos, new BlockPos(room.width, 1, room.length), 0.125, false, true);
                if (room == stack.highest()) {
                    TessellatorHelper.walls(bufferBuilder, pos.func_177982_a(0, room.height, 0), new BlockPos(room.width, 1, room.length), 0.125, false, true);
                }
            }));
            Tessellator.func_178181_a().func_78381_a();
            groundPlan.forEachStack(stack -> {
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                if (this.transparentStacks.contains(stack)) {
                    TessellatorTextures.RoomTransparent.bind();
                } else {
                    TessellatorTextures.Room.bind();
                }
                stack.forEach(room -> {
                    BlockPos pos = room.getOrigin().func_177971_a((Vec3i)anchor);
                    if (room == stack.highest()) {
                        TessellatorHelper.cube(bufferBuilder, pos, room.getSize(), 0.0, false, false);
                    } else {
                        TessellatorHelper.walls(bufferBuilder, pos, room.getSize(), 0.0, false, false);
                    }
                });
                Tessellator.func_178181_a().func_78381_a();
            });
        }
        this.renderRoof();
    }

    protected void renderRoof() {
        GroundPlan groundPlan = this.model.getGroundPlan();
        BlockPos anchor = this.model.getAnchor();
        if (groundPlan != null && anchor != null) {
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.color3f((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.lineWidth((float)10.0f);
            GlStateManager.disableTexture();
            groundPlan.forEachStack(stack -> {
                Room room = stack.highest();
                float x = room.x + anchor.func_177958_n();
                float y = (float)(room.y + anchor.func_177956_o()) + 0.5f;
                float z = room.z + anchor.func_177952_p();
                float h = room.height;
                float l = room.length;
                float w = room.width;
                bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                DesignType roofType = room.roofType;
                if (stack instanceof CylinderStack && roofType == DesignType.ROOF) {
                    roofType = DesignType.TOWER_ROOF;
                }
                boolean alongZ = w >= l;
                switch (roofType) {
                    case TOWER_ROOF: {
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)z).func_181675_d();
                        bufferBuilder.func_181662_b((double)(x + w / 2.0f), (double)(y + h + w), (double)(z + l / 2.0f)).func_181675_d();
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)(z + l)).func_181675_d();
                        Tessellator.func_178181_a().func_78381_a();
                        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h), (double)(z + l)).func_181675_d();
                        bufferBuilder.func_181662_b((double)(x + w / 2.0f), (double)(y + h + w), (double)(z + l / 2.0f)).func_181675_d();
                        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_181675_d();
                        Tessellator.func_178181_a().func_78381_a();
                        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                    }
                    case FLAT_ROOF: 
                    case TOWER_FLAT_ROOF: {
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)z).func_181675_d();
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)(z + l)).func_181675_d();
                        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h), (double)(z + l)).func_181675_d();
                        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_181675_d();
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)z).func_181675_d();
                        break;
                    }
                    case ROOF: {
                        boolean q = room.quadFacadeRoof;
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)z).func_181675_d();
                        if (alongZ || q) {
                            bufferBuilder.func_181662_b((double)x, (double)(y + h + l / 2.0f), (double)(z + l / 2.0f)).func_181675_d();
                        }
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)(z + l)).func_181675_d();
                        if (!alongZ || q) {
                            bufferBuilder.func_181662_b((double)(x + w / 2.0f), (double)(y + h + w / 2.0f), (double)(z + l)).func_181675_d();
                        }
                        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h), (double)(z + l)).func_181675_d();
                        if (alongZ || q) {
                            bufferBuilder.func_181662_b((double)(x + w), (double)(y + h + l / 2.0f), (double)(z + l / 2.0f)).func_181675_d();
                        }
                        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_181675_d();
                        if (!alongZ || q) {
                            bufferBuilder.func_181662_b((double)(x + w / 2.0f), (double)(y + h + w / 2.0f), (double)z).func_181675_d();
                        }
                        bufferBuilder.func_181662_b((double)x, (double)(y + h), (double)z).func_181675_d();
                        if (!alongZ || q) {
                            Tessellator.func_178181_a().func_78381_a();
                            bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                            bufferBuilder.func_181662_b((double)(x + w / 2.0f), (double)(y + h + w / 2.0f), (double)(z + l)).func_181675_d();
                            bufferBuilder.func_181662_b((double)(x + w / 2.0f), (double)(y + h + w / 2.0f), (double)z).func_181675_d();
                        }
                        if (!alongZ && !q) break;
                        Tessellator.func_178181_a().func_78381_a();
                        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                        bufferBuilder.func_181662_b((double)x, (double)(y + h + l / 2.0f), (double)(z + l / 2.0f)).func_181675_d();
                        bufferBuilder.func_181662_b((double)(x + w), (double)(y + h + l / 2.0f), (double)(z + l / 2.0f)).func_181675_d();
                        break;
                    }
                }
                Tessellator.func_178181_a().func_78381_a();
            });
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.lineWidth((float)1.0f);
            GlStateManager.enableTexture();
        }
    }
}

