/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.ArchitectManager;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.compose.GroundPlan;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.Stack;
import com.simibubi.mightyarchitect.control.compose.planner.GroundPlanningToolBase;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.ThemeStatistics;
import com.simibubi.mightyarchitect.control.helpful.Keyboard;
import com.simibubi.mightyarchitect.control.helpful.TessellatorHelper;
import com.simibubi.mightyarchitect.control.helpful.TessellatorTextures;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.mutable.MutableObject;

public class RoomTool
extends GroundPlanningToolBase {
    protected BlockPos firstPosition;
    protected Stack lastAddedStack;

    @Override
    public void init() {
        super.init();
        this.firstPosition = null;
        this.toolModeNoCtrl = "3-Grid";
        this.toolModeCtrl = "5-Grid";
        if (this.lastAddedStack != null && this.lastAddedStack.floors() == 0) {
            this.lastAddedStack = null;
        }
    }

    @Override
    public String handleRightClick() {
        super.handleRightClick();
        if (this.selectedPosition == null) {
            return null;
        }
        if (this.firstPosition == null) {
            this.firstPosition = this.selectedPosition;
            return "First position marked";
        }
        return this.createRoom(ArchitectManager.getModel().getGroundPlan());
    }

    protected String createRoom(GroundPlan groundPlan) {
        Room room = new Room(this.firstPosition, this.selectedPosition.func_177973_b((Vec3i)this.firstPosition));
        ++room.width;
        ++room.length;
        DesignTheme theme = groundPlan.theme;
        ThemeStatistics stats = theme.getStatistics();
        boolean hasFoundation = theme.getLayers().contains((Object)DesignLayer.Foundation);
        room.designLayer = hasFoundation ? DesignLayer.Foundation : DesignLayer.Regular;
        int facadeWidth = Math.min(room.width, room.length);
        if (facadeWidth % 2 == 0) {
            return "Facade cannot have even width: " + facadeWidth;
        }
        if (facadeWidth < stats.MinRoomLength) {
            return "Facade is too narrow (<" + stats.MinRoomLength + "): " + facadeWidth;
        }
        if (room.width > stats.MaxRoomLength) {
            return "Room is too large (>" + stats.MaxRoomLength + "): " + room.width;
        }
        if (room.length > stats.MaxRoomLength) {
            return "Room is too large (>" + stats.MaxRoomLength + "): " + room.length;
        }
        room.roofType = facadeWidth > stats.MaxGableRoof || !stats.hasGables ? (stats.hasFlatRoof ? DesignType.FLAT_ROOF : DesignType.NONE) : (stats.hasGables ? DesignType.ROOF : DesignType.NONE);
        this.lastAddedStack = new Stack(room);
        if (!this.adjustHeightForIntersection(groundPlan, room)) {
            room.height = theme.getDefaultHeightForFloor(0);
        }
        groundPlan.addStack(this.lastAddedStack);
        this.firstPosition = null;
        return "New Room has been added";
    }

    protected boolean adjustHeightForIntersection(GroundPlan groundPlan, Room room) {
        MutableObject biggestRoom = new MutableObject();
        if (room.height == 0) {
            room.height = 1;
        }
        groundPlan.forEachRoom(r -> {
            if (r.intersects(room) && r.y + r.height > room.y && room.y + room.height > r.y && (biggestRoom.getValue() == null || ((Room)biggestRoom.getValue()).width * ((Room)biggestRoom.getValue()).length < r.width * r.length)) {
                biggestRoom.setValue(r);
            }
        });
        if (biggestRoom.getValue() != null) {
            room.height = ((Room)biggestRoom.getValue()).y + ((Room)biggestRoom.getValue()).height - room.y;
            if (room.height > groundPlan.theme.getMaxFloorHeight()) {
                room.height -= ((Room)biggestRoom.getValue()).height;
            }
            return true;
        }
        return false;
    }

    public static void increaseMatchingOthers(GroundPlan groundPlan, Stack stack) {
        stack.increase();
        Room added = stack.highest();
        MutableObject biggestRoom = new MutableObject();
        groundPlan.forEachRoom(r -> {
            if (r == added) {
                return;
            }
            if (r.intersects(added) && r.y <= added.y && r.y + r.height > added.y && (biggestRoom.getValue() == null || ((Room)biggestRoom.getValue()).width * ((Room)biggestRoom.getValue()).length < r.width * r.length)) {
                biggestRoom.setValue(r);
            }
        });
        if (biggestRoom.getValue() != null) {
            added.height = ((Room)biggestRoom.getValue()).y + ((Room)biggestRoom.getValue()).height - added.y;
        }
    }

    @Override
    public boolean handleMouseWheel(int scroll) {
        if (this.lastAddedStack == null) {
            return false;
        }
        if (scroll > 0) {
            RoomTool.increaseMatchingOthers(ArchitectManager.getModel().getGroundPlan(), this.lastAddedStack);
        } else {
            this.lastAddedStack.decrease();
            if (this.lastAddedStack.floors() == 0) {
                ArchitectManager.getModel().getGroundPlan().remove(this.lastAddedStack);
                this.lastAddedStack = null;
            }
        }
        return true;
    }

    @Override
    public void updateSelection() {
        super.updateSelection();
        if (this.firstPosition == null) {
            return;
        }
        if (this.selectedPosition == null) {
            return;
        }
        BlockPos size = this.selectedPosition.func_177973_b((Vec3i)this.firstPosition);
        int xSize = size.func_177958_n();
        int zSize = size.func_177952_p();
        if (Keyboard.isKeyDown(341)) {
            int zr;
            int xr = (xSize + (xSize > 0 ? 2 : -2)) % 4;
            xr = xr < 0 ? (xr += 4) : 4 - xr;
            if (xr != 0) {
                this.selectedPosition = this.selectedPosition.func_177965_g(xSize > 0 ? xr : -xr);
            }
            zr = (zr = (zSize + (zSize > 0 ? 2 : -2)) % 4) < 0 ? (zr += 4) : 4 - zr;
            if (zr != 0) {
                this.selectedPosition = this.selectedPosition.func_177970_e(zSize > 0 ? zr : -zr);
            }
        } else {
            if (xSize % 2 != 0) {
                this.selectedPosition = this.selectedPosition.func_177965_g(xSize > 0 ? 1 : -1);
            }
            if (zSize % 2 != 0) {
                this.selectedPosition = this.selectedPosition.func_177970_e(zSize > 0 ? 1 : -1);
            }
        }
    }

    @Override
    public void renderTool() {
        if (this.selectedPosition == null) {
            return;
        }
        BlockPos anchor = ArchitectManager.getModel().getAnchor();
        BlockPos selectedPos = anchor != null ? this.selectedPosition.func_177971_a((Vec3i)anchor) : this.selectedPosition;
        BlockPos firstPos = this.firstPosition != null ? this.firstPosition.func_177971_a((Vec3i)anchor) : null;
        TessellatorTextures.Selection.bind();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TessellatorHelper.walls(bufferBuilder, selectedPos, new BlockPos(1, 1, 1), 0.125, false, true);
        if (firstPos != null) {
            BlockPos size = selectedPos.func_177973_b((Vec3i)firstPos);
            Cuboid selection = new Cuboid(firstPos, size.func_177958_n(), 1, size.func_177952_p());
            ++selection.width;
            ++selection.length;
            TessellatorHelper.walls(bufferBuilder, selection.getOrigin(), selection.getSize(), -0.125, false, true);
            Tessellator.func_178181_a().func_78381_a();
            TessellatorHelper.drawString("" + selection.width, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z - 1, true, false);
            TessellatorHelper.drawString("" + selection.width, (float)selection.x + (float)selection.width / 2.0f, (float)selection.y + 0.5f, selection.z + selection.length + 1, true, false);
            TessellatorHelper.drawString("" + selection.length, selection.x + selection.width + 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, true, false);
            TessellatorHelper.drawString("" + selection.length, selection.x - 1, (float)selection.y + 0.5f, (float)selection.z + (float)selection.length / 2.0f, true, false);
        } else {
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

