/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.compose.planner;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.mightyarchitect.control.compose.Cuboid;
import com.simibubi.mightyarchitect.control.compose.Room;
import com.simibubi.mightyarchitect.control.compose.planner.ComposerToolBase;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class WallDecorationToolBase
extends ComposerToolBase {
    protected boolean highlightStack;
    protected boolean highlightRoom;
    protected boolean highlightRoof;

    @Override
    public void init() {
        super.init();
        this.highlightStack = false;
        this.highlightRoom = false;
        this.highlightRoof = false;
    }

    @Override
    public boolean handleMouseWheel(int scroll) {
        return false;
    }

    @Override
    public String handleRightClick() {
        return null;
    }

    @Override
    public void renderGroundPlan() {
    }

    @Override
    public void renderTool() {
        GlStateManager.lineWidth((float)5.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableTexture();
        if (this.highlightStack && selectedStack != null) {
            Cuboid stack = new Cuboid(selectedStack.lowest().getOrigin(), BlockPos.field_177992_a);
            stack.height = WallDecorationToolBase.selectedStack.highest().y + WallDecorationToolBase.selectedStack.highest().height;
            for (Room room : selectedStack.getRooms()) {
                if (stack.x > room.x) {
                    stack.width += stack.x - room.x;
                    stack.x = room.x;
                }
                if (stack.z > room.z) {
                    stack.length += stack.z - room.z;
                    stack.z = room.z;
                }
                if (stack.x + stack.width < room.x + room.width) {
                    stack.width += room.x + room.width - (stack.x + stack.width);
                }
                if (stack.z + stack.length >= room.z + room.length) continue;
                stack.length += room.z + room.length - (stack.z + stack.length);
            }
            BlockPos min = stack.getOrigin().func_177971_a((Vec3i)this.model.getAnchor());
            BlockPos max = stack.getOrigin().func_177971_a((Vec3i)stack.getSize()).func_177971_a((Vec3i)this.model.getAnchor());
            WorldRenderer.func_189694_a((double)((double)min.func_177958_n() - 0.5), (double)((double)min.func_177956_o() + 0.25), (double)((double)min.func_177952_p() - 0.5), (double)((double)max.func_177958_n() + 0.5), (double)max.func_177956_o(), (double)((double)max.func_177952_p() + 0.5), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.highlightRoom && selectedRoom != null) {
            BlockPos min = selectedRoom.getOrigin().func_177971_a((Vec3i)this.model.getAnchor());
            BlockPos max = selectedRoom.getOrigin().func_177971_a((Vec3i)selectedRoom.getSize()).func_177971_a((Vec3i)this.model.getAnchor());
            if (this.highlightRoof && selectedRoom == selectedStack.highest() && selectedFace == Direction.UP) {
                min = min.func_177982_a(0, WallDecorationToolBase.selectedRoom.height, 0);
                max = max.func_177982_a(0, WallDecorationToolBase.selectedRoom.height, 0);
                WorldRenderer.func_189694_a((double)((double)min.func_177958_n() - 0.5), (double)((double)min.func_177956_o() + 0.25), (double)((double)min.func_177952_p() - 0.5), (double)((double)max.func_177958_n() + 0.5), (double)max.func_177956_o(), (double)((double)max.func_177952_p() + 0.5), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                WorldRenderer.func_189694_a((double)((double)min.func_177958_n() - 0.5), (double)((double)min.func_177956_o() + 0.25), (double)((double)min.func_177952_p() - 0.5), (double)((double)max.func_177958_n() + 0.5), (double)max.func_177956_o(), (double)((double)max.func_177952_p() + 0.5), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.enableTexture();
    }
}

