/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignPicker;
import com.simibubi.mightyarchitect.control.design.DesignResourceLoader;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.design.ThemeStatistics;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class DesignTheme {
    private static final List<Integer> defaultHeightSequence = ImmutableList.of((Object)2, (Object)4);
    private String filePath;
    private String displayName;
    private String designer;
    private DesignPicker designPicker;
    private boolean imported;
    private PaletteDefinition defaultPalette;
    private PaletteDefinition defaultSecondaryPalette;
    private ThemeStatistics statistics;
    private int maxFloorHeight;
    private List<Integer> heightSequence;
    private List<DesignLayer> roomLayers;
    private List<DesignLayer> layers;
    private List<DesignType> types;
    private Map<DesignLayer, Map<DesignType, Set<Design>>> designs;

    public DesignTheme(String displayName, String designer) {
        this.designer = designer;
        this.displayName = displayName;
        this.designPicker = new DesignPicker();
        this.designPicker.setTheme(this);
        this.imported = false;
        this.maxFloorHeight = 10;
        this.heightSequence = defaultHeightSequence;
    }

    public DesignTheme withLayers(DesignLayer ... designLayers) {
        this.layers = ImmutableList.copyOf((Object[])designLayers);
        this.updateRoomLayers();
        return this;
    }

    public DesignTheme withHeightSequence(List<Integer> seq) {
        this.heightSequence = seq;
        return this;
    }

    protected void updateRoomLayers() {
        this.roomLayers = new ArrayList<DesignLayer>();
        this.roomLayers.addAll(this.layers);
        this.roomLayers.remove((Object)DesignLayer.Roofing);
    }

    public DesignTheme withTypes(DesignType ... designtypes) {
        this.types = ImmutableList.copyOf((Object[])designtypes);
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDefaultHeightForFloor(int floor) {
        return this.heightSequence.size() <= floor ? -1 : this.heightSequence.get(floor);
    }

    public DesignPicker getDesignPicker() {
        return this.designPicker;
    }

    public List<DesignLayer> getLayers() {
        return this.layers;
    }

    public List<DesignType> getTypes() {
        return this.types;
    }

    public boolean isImported() {
        return this.imported;
    }

    public Set<Design> getDesigns(DesignLayer designLayer, DesignType designType) {
        Map<DesignType, Set<Design>> typeMap;
        if (this.designs == null) {
            this.initDesigns();
        }
        if (this.designs.containsKey((Object)designLayer) && (typeMap = this.designs.get((Object)designLayer)).containsKey((Object)designType)) {
            return typeMap.get((Object)designType);
        }
        return new HashSet<Design>();
    }

    protected void initDesigns() {
        this.designs = DesignResourceLoader.loadDesignsForTheme(this);
        this.statistics = ThemeStatistics.evaluate(this);
    }

    public ThemeStatistics getStatistics() {
        if (this.designs == null) {
            this.initDesigns();
        }
        return this.statistics;
    }

    public void clearDesigns() {
        this.designs = null;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDesigner() {
        return this.designer;
    }

    public void setLayers(List<DesignLayer> layers) {
        this.layers = layers;
        this.updateRoomLayers();
    }

    public void setTypes(List<DesignType> types) {
        this.types = types;
    }

    public CompoundNBT asTagCompound() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("Name", this.getDisplayName());
        compound.func_74778_a("Designer", this.getDesigner());
        ListNBT layers = new ListNBT();
        ListNBT types = new ListNBT();
        this.layers.forEach(layer -> layers.add((Object)new StringNBT(layer.name())));
        this.types.forEach(type -> types.add((Object)new StringNBT(type.name())));
        compound.func_218657_a("Layers", (INBT)layers);
        compound.func_218657_a("Types", (INBT)types);
        compound.func_74768_a("Maximum Room Height", this.maxFloorHeight);
        return compound;
    }

    public static DesignTheme fromNBT(CompoundNBT compound) {
        if (compound == null) {
            return null;
        }
        DesignTheme theme = new DesignTheme(compound.func_74779_i("Name"), compound.func_74779_i("Designer"));
        theme.layers = new ArrayList<DesignLayer>();
        theme.types = new ArrayList<DesignType>();
        if (compound.func_74764_b("Maximum Room Height")) {
            theme.maxFloorHeight = compound.func_74762_e("Maximum Room Height");
        }
        compound.func_150295_c("Layers", 8).forEach(s -> theme.layers.add(DesignLayer.valueOf(((StringNBT)s).func_150285_a_())));
        compound.func_150295_c("Types", 8).forEach(s -> theme.types.add(DesignType.valueOf(((StringNBT)s).func_150285_a_())));
        theme.updateRoomLayers();
        return theme;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    public PaletteDefinition getDefaultPalette() {
        return this.defaultPalette;
    }

    public void setDefaultPalette(PaletteDefinition defaultPalette) {
        this.defaultPalette = defaultPalette;
    }

    public PaletteDefinition getDefaultSecondaryPalette() {
        return this.defaultSecondaryPalette;
    }

    public void setDefaultSecondaryPalette(PaletteDefinition defaultSecondaryPalette) {
        this.defaultSecondaryPalette = defaultSecondaryPalette;
    }

    public List<DesignLayer> getRoomLayers() {
        return this.roomLayers;
    }

    public int getMaxFloorHeight() {
        return this.maxFloorHeight;
    }

    public void setMaxFloorHeight(int maxFloorHeight) {
        this.maxFloorHeight = maxFloorHeight;
    }
}

