/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.google.common.collect.ImmutableList;
import com.simibubi.mightyarchitect.control.design.partials.Corner;
import com.simibubi.mightyarchitect.control.design.partials.Design;
import com.simibubi.mightyarchitect.control.design.partials.Facade;
import com.simibubi.mightyarchitect.control.design.partials.FlatRoof;
import com.simibubi.mightyarchitect.control.design.partials.Roof;
import com.simibubi.mightyarchitect.control.design.partials.Tower;
import com.simibubi.mightyarchitect.control.design.partials.TowerFlatRoof;
import com.simibubi.mightyarchitect.control.design.partials.TowerRoof;
import com.simibubi.mightyarchitect.control.design.partials.Trim;
import com.simibubi.mightyarchitect.control.design.partials.Wall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum DesignType {
    WALL("wall", "Wall", new Wall()),
    FACADE("facade", "Facade", new Facade()),
    CORNER("corner", "Corner", new Corner()),
    TOWER("tower", "Tower", new Tower()),
    TRIM("trim", "Trim", new Trim()),
    ROOF("roof", "Gable Roof", new Roof()),
    FLAT_ROOF("flatroof", "Flat Roof", new FlatRoof()),
    TOWER_ROOF("towerroof", "Conical Roof", new TowerRoof()),
    TOWER_FLAT_ROOF("towerflatroof", "Flat Tower Roof", new TowerFlatRoof()),
    NONE("none", "None", null);

    private String filePath;
    private String displayName;
    private Design design;

    private DesignType(String filePath, String displayName, Design design) {
        this.filePath = filePath;
        this.displayName = displayName;
        this.design = design;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Design getDesign() {
        return this.design;
    }

    public boolean hasAdditionalData() {
        return this.hasSizeData() || this.hasSubtypes();
    }

    public String getAdditionalDataName() {
        switch (this) {
            case ROOF: {
                return "Roof Span";
            }
            case FLAT_ROOF: {
                return "Margin";
            }
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                return "Tower Radius";
            }
            case WALL: {
                return "Size Behaviour";
            }
        }
        return "";
    }

    public boolean hasSizeData() {
        switch (this) {
            case ROOF: 
            case FLAT_ROOF: 
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                return true;
            }
        }
        return false;
    }

    public int getMaxSize() {
        switch (this) {
            case ROOF: {
                return 35;
            }
            case FLAT_ROOF: {
                return 15;
            }
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                return 15;
            }
        }
        return 0;
    }

    public int getMinSize() {
        switch (this) {
            case ROOF: {
                return 3;
            }
            case FLAT_ROOF: {
                return 0;
            }
            case TOWER: 
            case TOWER_FLAT_ROOF: 
            case TOWER_ROOF: {
                return 1;
            }
        }
        return 0;
    }

    public boolean hasSubtypes() {
        switch (this) {
            case WALL: {
                return true;
            }
        }
        return false;
    }

    public List<String> getSubtypeOptions() {
        switch (this) {
            case WALL: {
                ArrayList<String> list = new ArrayList<String>();
                ImmutableList.copyOf((Object[])Wall.ExpandBehaviour.values()).forEach(value -> list.add(value.name()));
                return list;
            }
        }
        return Collections.emptyList();
    }

    public static List<DesignType> defaults() {
        return ImmutableList.of((Object)((Object)WALL), (Object)((Object)FACADE), (Object)((Object)CORNER));
    }

    public static List<DesignType> roofTypes() {
        return ImmutableList.of((Object)((Object)ROOF), (Object)((Object)FLAT_ROOF), (Object)((Object)TOWER_FLAT_ROOF), (Object)((Object)TOWER_ROOF));
    }
}

