/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.design;

import com.simibubi.mightyarchitect.control.design.DesignLayer;
import com.simibubi.mightyarchitect.control.design.DesignResourceLoader;
import com.simibubi.mightyarchitect.control.design.DesignTheme;
import com.simibubi.mightyarchitect.control.design.DesignType;
import com.simibubi.mightyarchitect.control.helpful.FilesHelper;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class ThemeStorage {
    private static List<DesignTheme> importedThemes;
    private static List<DesignTheme> createdThemes;

    public static List<DesignTheme> getAllThemes() {
        ArrayList<DesignTheme> themes = new ArrayList<DesignTheme>(ThemeStorage.getIncluded());
        themes.addAll(ThemeStorage.getImported());
        return themes;
    }

    public static List<DesignTheme> getIncluded() {
        ArrayList<DesignTheme> included = new ArrayList<DesignTheme>();
        for (IncludedThemes theme : IncludedThemes.values()) {
            if (theme.theme == null) {
                theme.theme = ThemeStorage.loadInternalTheme(theme.themeFolder).withHeightSequence(theme.heights);
            }
            if (theme == IncludedThemes.Fallback) continue;
            included.add(theme.theme);
        }
        return included;
    }

    public static List<DesignTheme> getImported() {
        if (importedThemes == null) {
            ThemeStorage.importThemes();
        }
        return importedThemes;
    }

    public static List<DesignTheme> getCreated() {
        if (createdThemes == null) {
            ThemeStorage.importThemes();
        }
        return createdThemes;
    }

    public static void reloadExternal() {
        importedThemes = null;
        createdThemes = null;
    }

    public static DesignTheme createTheme(String name) {
        if (name.isEmpty()) {
            name = "My Theme";
        }
        DesignTheme theme = new DesignTheme(name, Minecraft.func_71410_x().field_71439_g.func_200200_C_().func_150254_d());
        theme.setFilePath(FilesHelper.slug(name));
        theme.setImported(true);
        theme.setDefaultPalette(PaletteDefinition.defaultPalette());
        theme.setDefaultSecondaryPalette(PaletteDefinition.defaultPalette());
        return theme.withLayers(DesignLayer.Regular, DesignLayer.Roofing, DesignLayer.Foundation).withTypes(DesignType.WALL, DesignType.CORNER, DesignType.ROOF, DesignType.FACADE, DesignType.FLAT_ROOF);
    }

    public static void exportTheme(DesignTheme theme) {
        String folderPath = "themes";
        FilesHelper.createFolderIfMissing(folderPath);
        String foldername = theme.getFilePath();
        FilesHelper.createFolderIfMissing(folderPath + "/" + foldername);
        String filepath = folderPath + "/" + foldername + "/theme.json";
        FilesHelper.saveTagCompoundAsJson(theme.asTagCompound(), filepath);
        String palettePath = folderPath + "/" + foldername + "/palette.json";
        FilesHelper.saveTagCompoundAsJson(theme.getDefaultPalette().writeToNBT(new CompoundNBT()), palettePath);
        String palette2Path = folderPath + "/" + foldername + "/palette2.json";
        FilesHelper.saveTagCompoundAsJson(theme.getDefaultSecondaryPalette().writeToNBT(new CompoundNBT()), palette2Path);
    }

    public static String exportThemeFullyAsFile(DesignTheme theme, boolean compressed) {
        String folderPath = "themes/export";
        FilesHelper.createFolderIfMissing(folderPath);
        CompoundNBT massiveThemeTag = new CompoundNBT();
        massiveThemeTag.func_218657_a("Theme", (INBT)theme.asTagCompound());
        massiveThemeTag.func_218657_a("Palette", (INBT)theme.getDefaultPalette().writeToNBT(new CompoundNBT()));
        massiveThemeTag.func_218657_a("SecondaryPalette", (INBT)theme.getDefaultSecondaryPalette().writeToNBT(new CompoundNBT()));
        Map<DesignLayer, Map<DesignType, Set<CompoundNBT>>> designFiles = DesignResourceLoader.loadThemeFromFolder(theme);
        CompoundNBT layers = new CompoundNBT();
        for (DesignLayer layer : theme.getLayers()) {
            if (!designFiles.containsKey((Object)layer)) continue;
            CompoundNBT types = new CompoundNBT();
            for (DesignType type : theme.getTypes()) {
                if (!designFiles.get((Object)layer).containsKey((Object)type)) continue;
                ListNBT designs = new ListNBT();
                for (CompoundNBT tag : designFiles.get((Object)layer).get((Object)type)) {
                    designs.add((Object)tag);
                }
                types.func_218657_a(type.name(), (INBT)designs);
            }
            layers.func_218657_a(layer.name(), (INBT)types);
        }
        massiveThemeTag.func_218657_a("Designs", (INBT)layers);
        if (compressed) {
            try {
                Path path = Paths.get(folderPath + "/" + theme.getFilePath() + ".theme", new String[0]);
                Files.deleteIfExists(path);
                OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);
                CompressedStreamTools.func_74799_a((CompoundNBT)massiveThemeTag, (OutputStream)outputStream);
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            FilesHelper.saveTagCompoundAsJsonCompact(massiveThemeTag, folderPath + "/" + theme.getFilePath() + ".json");
        }
        return theme.getFilePath() + (compressed ? ".theme" : ".json");
    }

    public static DesignTheme importThemeFullyFromFile(String path) {
        return null;
    }

    private static DesignTheme loadInternalTheme(String themeFolder) {
        CompoundNBT themeCompound = FilesHelper.loadJsonResourceAsNBT("themes/" + themeFolder + "/theme.json");
        CompoundNBT paletteCompound = FilesHelper.loadJsonResourceAsNBT("themes/" + themeFolder + "/palette.json");
        CompoundNBT palette2Compound = FilesHelper.loadJsonResourceAsNBT("themes/" + themeFolder + "/palette2.json");
        DesignTheme theme = DesignTheme.fromNBT(themeCompound);
        theme.setFilePath(themeFolder);
        theme.setImported(false);
        theme.setDefaultPalette(PaletteDefinition.fromNBT(paletteCompound));
        theme.setDefaultSecondaryPalette(PaletteDefinition.fromNBT(palette2Compound));
        return theme;
    }

    private static void importThemes() {
        importedThemes = new ArrayList<DesignTheme>();
        createdThemes = new ArrayList<DesignTheme>();
        String folderPath = "themes";
        try {
            if (!Files.isDirectory(Paths.get(folderPath, new String[0]), new LinkOption[0])) {
                Files.createDirectory(Paths.get(folderPath, new String[0]), new FileAttribute[0]);
            }
            DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(Paths.get(folderPath, new String[0]));
            for (Path path : newDirectoryStream) {
                CompoundNBT paletteCompound;
                CompoundNBT themeCompound;
                String themeFolder = path.getFileName().toString();
                CompoundNBT secondaryPaletteCompound = null;
                if (themeFolder.equals("export")) continue;
                if (themeFolder.endsWith(".theme") || themeFolder.endsWith(".json")) {
                    CompoundNBT themeFile = new CompoundNBT();
                    if (themeFolder.endsWith(".theme")) {
                        try {
                            InputStream inputStream = Files.newInputStream(Paths.get(folderPath + "/" + themeFolder, new String[0]), StandardOpenOption.READ);
                            themeFile = CompressedStreamTools.func_74796_a((InputStream)inputStream);
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        themeFile = FilesHelper.loadJsonAsNBT("themes/" + themeFolder);
                    }
                    themeCompound = themeFile.func_74775_l("Theme");
                    paletteCompound = themeFile.func_74775_l("Palette");
                    if (themeFile.func_74764_b("SecondaryPalette")) {
                        secondaryPaletteCompound = themeFile.func_74775_l("SecondaryPalette");
                    }
                } else {
                    themeCompound = FilesHelper.loadJsonAsNBT(folderPath + "/" + themeFolder + "/theme.json");
                    paletteCompound = FilesHelper.loadJsonAsNBT(folderPath + "/" + themeFolder + "/palette.json");
                    secondaryPaletteCompound = FilesHelper.loadJsonAsNBT(folderPath + "/" + themeFolder + "/palette2.json");
                }
                if (themeCompound == null) continue;
                DesignTheme theme = DesignTheme.fromNBT(themeCompound);
                theme.setFilePath(themeFolder);
                theme.setImported(true);
                theme.setDefaultPalette(PaletteDefinition.fromNBT(paletteCompound));
                if (secondaryPaletteCompound != null) {
                    theme.setDefaultSecondaryPalette(PaletteDefinition.fromNBT(secondaryPaletteCompound));
                } else {
                    theme.setDefaultSecondaryPalette(theme.getDefaultPalette());
                }
                importedThemes.add(theme);
                if (themeFolder.endsWith(".theme") || themeFolder.endsWith(".json")) continue;
                createdThemes.add(theme);
            }
            newDirectoryStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum IncludedThemes {
        Medieval("medieval", 3, 5),
        Fallback("fallback_theme", 3, 4),
        Modern("modern", 2, 4),
        TownHouse("town_house", 4, 5),
        Cattingham("cattingham_palace", 7, 2, 6);

        public DesignTheme theme;
        public String themeFolder;
        public List<Integer> heights;

        private IncludedThemes(String themeFolder, Integer ... floorHeights) {
            this.themeFolder = themeFolder;
            this.heights = Arrays.asList(floorHeights);
        }
    }
}

