/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.helpful;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;

public class FilesHelper {
    public static void createFolderIfMissing(String name) {
        if (!Files.isDirectory(Paths.get(name, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(Paths.get(name, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                TheMightyArchitect.logger.warn("Could not create Folder: " + name);
            }
        }
    }

    public static String findFirstValidFilename(String name, String folderPath, String extension) {
        String filename;
        String filepath;
        int index = 0;
        do {
            filename = FilesHelper.slug(name) + (index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(Paths.get(filepath = folderPath + "/" + filename, new String[0]), new LinkOption[0]));
        return filename;
    }

    public static String slug(String name) {
        return name.toLowerCase().replace(' ', '_');
    }

    public static boolean saveTagCompoundAsJson(CompoundNBT compound, String path) {
        try {
            Files.deleteIfExists(Paths.get(path, new String[0]));
            JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(Paths.get(path, new String[0]), StandardOpenOption.CREATE));
            writer.setIndent("  ");
            Streams.write((JsonElement)new JsonParser().parse(compound.toString()), (JsonWriter)writer);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveTagCompoundAsJsonCompact(CompoundNBT compound, String path) {
        try {
            Files.deleteIfExists(Paths.get(path, new String[0]));
            JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(Paths.get(path, new String[0]), StandardOpenOption.CREATE));
            Streams.write((JsonElement)new JsonParser().parse(compound.toString()), (JsonWriter)writer);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static CompoundNBT loadJsonNBT(InputStream inputStream) {
        try {
            JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(inputStream)));
            reader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)reader);
            reader.close();
            inputStream.close();
            return JsonToNBT.func_180713_a((String)element.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static CompoundNBT loadJsonResourceAsNBT(String filepath) {
        return FilesHelper.loadJsonNBT(TheMightyArchitect.class.getClassLoader().getResourceAsStream(filepath));
    }

    public static CompoundNBT loadJsonAsNBT(String filepath) {
        try {
            return FilesHelper.loadJsonNBT(Files.newInputStream(Paths.get(filepath, new String[0]), StandardOpenOption.READ));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

