/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.mightyarchitect.control.palette;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.mightyarchitect.TheMightyArchitect;
import com.simibubi.mightyarchitect.control.helpful.FilesHelper;
import com.simibubi.mightyarchitect.control.palette.PaletteDefinition;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;

public class PaletteStorage {
    private static Map<String, PaletteDefinition> palettes;
    private static Map<String, PaletteDefinition> resourcePalettes;

    public static PaletteDefinition getRandomPalette() {
        if (palettes == null) {
            PaletteStorage.loadAllPalettes();
        }
        Random random = new Random();
        ArrayList<String> names = new ArrayList<String>(palettes.keySet());
        PaletteDefinition palette = palettes.get(names.get(random.nextInt(names.size())));
        return palette;
    }

    public static PaletteDefinition getPalette(String name) {
        if (palettes == null) {
            PaletteStorage.loadAllPalettes();
        }
        if (palettes.containsKey(name)) {
            return palettes.get(name);
        }
        return resourcePalettes.get(name);
    }

    public static List<String> getPaletteNames() {
        if (palettes == null) {
            PaletteStorage.loadAllPalettes();
        }
        return new ArrayList<String>(palettes.keySet());
    }

    public static List<String> getResourcePaletteNames() {
        if (resourcePalettes == null) {
            PaletteStorage.loadAllPalettes();
        }
        return new ArrayList<String>(resourcePalettes.keySet());
    }

    public static void exportPalette(PaletteDefinition palette) {
        String folderPath = "palettes";
        FilesHelper.createFolderIfMissing(folderPath);
        String filename = FilesHelper.findFirstValidFilename(palette.getName(), folderPath, "json");
        String filepath = folderPath + "/" + filename;
        FilesHelper.saveTagCompoundAsJson(palette.writeToNBT(new CompoundNBT()), filepath);
    }

    public static PaletteDefinition importPalette(Path path) {
        try {
            JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(path));
            reader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)reader);
            return PaletteDefinition.fromNBT(JsonToNBT.func_180713_a((String)element.toString()));
        }
        catch (CommandSyntaxException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void loadAllPalettes() {
        palettes = new HashMap<String, PaletteDefinition>();
        resourcePalettes = new HashMap<String, PaletteDefinition>();
        PaletteStorage.loadResourcePalettes();
        try {
            Files.list(Paths.get("palettes/", new String[0])).forEach(path -> PaletteStorage.loadPalette(path));
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadPalette(Path path) {
        PaletteDefinition palette = PaletteStorage.importPalette(path);
        palettes.put(palette.getName(), palette);
    }

    public static void loadResourcePalettes() {
        for (int index = 0; index < 2048; ++index) {
            String path = "palettes/p" + index + ".json";
            if (TheMightyArchitect.class.getClassLoader().getResource(path) == null) break;
            CompoundNBT tag = FilesHelper.loadJsonResourceAsNBT(path);
            PaletteDefinition paletteDefinition = PaletteDefinition.fromNBT(tag);
            resourcePalettes.put(paletteDefinition.getName(), paletteDefinition);
        }
    }
}

